/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;

public class DuccGarbageStatsCollector {
    MBeanServerConnection connection = null;
    DuccLogger logger = null;
    IDuccProcess process = null;
    JmxUrl jmxUrl = null;
    private boolean reportJmxUrl = true;

    public DuccGarbageStatsCollector(DuccLogger logger, IDuccProcess process) {
        this.logger = logger;
        this.process = process;
        try {
            this.jmxUrl = new JmxUrl(process);
        }
        catch (Exception e) {
            logger.error("DuccGarbageStatsCollector.ctor", null, (Throwable)e, new Object[0]);
        }
    }

    private MBeanServerConnection getServerConnection() throws Exception {
        this.logger.info("DuccGarbageStatsCollector.getServerConnection()", null, new Object[]{"Connecting GC collector to remote child process - URL:" + this.jmxUrl.get()});
        JMXServiceURL url = new JMXServiceURL(this.jmxUrl.get());
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        return jmxc.getMBeanServerConnection();
    }

    public ProcessGarbageCollectionStats collect() {
        ProcessGarbageCollectionStats gcStats = new ProcessGarbageCollectionStats();
        try {
            if (this.connection == null) {
                this.connection = this.getServerConnection();
            }
            Set<ObjectInstance> mbeans = this.connection.queryMBeans(new ObjectName("java.lang:type=GarbageCollector,*"), null);
            Long totalCollectionCount = new Long(0L);
            Long totalCollectionTime = new Long(0L);
            for (ObjectInstance gcObject : mbeans) {
                String gcCollectorName = gcObject.getObjectName().getCanonicalKeyPropertyListString();
                ObjectName memoryManagerMXBean = new ObjectName("java.lang:" + gcCollectorName);
                totalCollectionCount = totalCollectionCount + (Long)this.connection.getAttribute(memoryManagerMXBean, "CollectionCount");
                totalCollectionTime = totalCollectionTime + (Long)this.connection.getAttribute(memoryManagerMXBean, "CollectionTime");
            }
            gcStats.setCollectionCount(totalCollectionCount.longValue());
            gcStats.setCollectionTime(totalCollectionTime.longValue());
            this.logger.debug("DuccGarbageStatsCollector.collect()", null, new Object[]{"GC Collector Fetch Stats For PID:" + this.process.getPID() + " GC Count:" + gcStats.getCollectionCount() + " GC Time:" + gcStats.getCollectionTime()});
        }
        catch (Throwable e) {
            this.connection = null;
            this.logger.error("", null, new Object[]{"Failed to Fetch JMX GC Stats From PID:" + this.process.getPID() + " Reason:\n" + e});
            this.logger.info("DuccGarbageStatsCollector.collect()", null, new Object[]{"GC Collector Failed to Connect via JMX to child process PID:" + this.process.getPID() + " JmxUrl:" + this.jmxUrl.get() + " Will try to reconnect later"});
        }
        return gcStats;
    }

    private class JmxUrl {
        IDuccProcess process = null;

        public JmxUrl(IDuccProcess remoteProcess) {
            this.process = remoteProcess;
        }

        public boolean isAvailable() {
            return this.process != null && this.process.getProcessJmxUrl() != null && this.process.getProcessJmxUrl().trim().length() > 0;
        }

        public String get() {
            if (this.isAvailable()) {
                if (DuccGarbageStatsCollector.this.reportJmxUrl) {
                    DuccGarbageStatsCollector.this.reportJmxUrl = false;
                    DuccGarbageStatsCollector.this.logger.info("JmxUrl.get()", null, new Object[]{"Remote Process JMX URL:" + this.process.getProcessJmxUrl()});
                }
                return this.process.getProcessJmxUrl();
            }
            return "";
        }
    }
}

