/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jd;

import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.ducc.user.jd.JdUser;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public class JdUserCasManager {
    private String CAS_INITIAL_HEAP_SIZE = JdUser.CAS_INITIAL_HEAP_SIZE;
    private ConcurrentLinkedQueue<CAS> recycledCasList = new ConcurrentLinkedQueue();
    private TypeSystemDescription tsd = null;
    private TypePriorities tp = null;
    private FsIndexDescription[] fid;
    private Properties crProperties = new Properties();

    public JdUserCasManager(CollectionReader cr) {
        this.setTypeSystemDescription(cr.getProcessingResourceMetaData().getTypeSystem());
        this.setTypePriorities(cr.getProcessingResourceMetaData().getTypePriorities());
        this.setFsIndexDescription(cr.getProcessingResourceMetaData().getFsIndexes());
        this.initCrProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CAS getEmptyCas() throws ResourceInitializationException {
        CAS cas = this.recycledCasList.poll();
        if (cas != null) return cas;
        Class<CasCreationUtils> clazz = CasCreationUtils.class;
        synchronized (CasCreationUtils.class) {
            return CasCreationUtils.createCas((TypeSystemDescription)this.tsd, (TypePriorities)this.tp, (FsIndexDescription[])this.fid, (Properties)this.crProperties);
        }
    }

    public void recycle(CAS cas) {
        cas.reset();
        this.recycledCasList.add(cas);
    }

    private void setTypeSystemDescription(TypeSystemDescription value) {
        this.tsd = value;
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.tsd;
    }

    private void setTypePriorities(TypePriorities value) {
        this.tp = value;
    }

    public TypePriorities getTypePriorities() {
        return this.tp;
    }

    private void setFsIndexDescription(FsIndexDescription[] value) {
        this.fid = value;
    }

    public FsIndexDescription[] getFsIndexDescription() {
        return this.fid;
    }

    private void initCrProperties() {
        this.crProperties.setProperty("cas_initial_heap_size", this.CAS_INITIAL_HEAP_SIZE);
    }
}

