/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.head;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public abstract class ADuccHead
implements IDuccHead {
    private static DuccLogger logger = null;
    private static DuccId jobid = null;
    private AtomicReference<String> state = new AtomicReference<String>(initial);

    public ADuccHead(DuccLogger logger) {
        this.setLogger(logger);
        this.init();
    }

    private void init() {
        String location = "init";
        String prev = this.state.get();
        this.query_ducc_head_mode();
        String curr = this.state.get();
        logger.info(location, jobid, prev, "->", curr);
    }

    private void setLogger(DuccLogger value) {
        logger = value;
    }

    private String joiner(String lhs, String rhs) {
        String retVal = lhs;
        if (lhs != null && rhs != null) {
            retVal = lhs + File.separator + rhs;
            retVal = retVal.replaceAll("/+", "/");
        }
        return retVal;
    }

    private String getCommand() {
        String ducc_home = IDuccEnv.DUCC_HOME_DIR;
        String admin_ducc_master_py = "admin" + File.separator + "ducc_head_mode.py";
        String retVal = this.joiner(ducc_home, admin_ducc_master_py);
        return retVal;
    }

    private String runCmd() {
        String location = "runCmd";
        String retVal = null;
        try {
            String line;
            String command = this.getCommand();
            logger.debug(location, jobid, command);
            String[] pb_command = new String[]{command};
            ProcessBuilder pb = new ProcessBuilder(pb_command);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(pOut);
            BufferedReader br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                logger.debug(location, jobid, line);
            }
            retVal = sb.toString();
            int rc = p.waitFor();
            logger.debug(location, jobid, rc);
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public String get_ducc_head_mode() {
        String curr = this.state.get();
        return curr;
    }

    private void query_ducc_head_mode() {
        String location = "query_ducc_head_mode";
        String prev = this.state.get();
        String curr = this.runCmd();
        if (curr == null) {
            curr = master;
        }
        this.state.set(curr);
        logger.debug(location, jobid, prev, "->", curr);
    }

    private boolean isEqual(String a, String b) {
        boolean retVal = false;
        if (a != null && b != null) {
            retVal = a.equals(b);
        }
        return retVal;
    }

    @Override
    public boolean is_ducc_head_unspecified() {
        boolean retVal = false;
        String curr = this.state.get();
        retVal = this.isEqual(curr, unspecified);
        return retVal;
    }

    @Override
    public boolean is_ducc_head_reliable() {
        boolean retVal = false;
        String curr = this.state.get();
        retVal = this.isEqual(curr, master) || this.isEqual(curr, backup);
        return retVal;
    }

    @Override
    public boolean is_ducc_head_master() {
        boolean retVal = false;
        String curr = this.state.get();
        retVal = this.isEqual(curr, master);
        return retVal;
    }

    @Override
    public boolean is_ducc_head_virtual_master() {
        boolean retVal = false;
        String curr = this.state.get();
        retVal = this.isEqual(curr, master) || this.isEqual(curr, unspecified);
        return retVal;
    }

    @Override
    public boolean is_ducc_head_backup() {
        boolean retVal = false;
        String curr = this.state.get();
        retVal = this.isEqual(curr, backup);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDuccHead.DuccHeadTransition transition() {
        String location = "transition";
        IDuccHead.DuccHeadTransition retVal = IDuccHead.DuccHeadTransition.unspecified;
        try {
            Class<ADuccHead> clazz = ADuccHead.class;
            synchronized (ADuccHead.class) {
                String prev = this.state.get();
                this.query_ducc_head_mode();
                String curr = this.state.get();
                if (this.isEqual(prev, master)) {
                    if (this.isEqual(curr, master)) {
                        retVal = IDuccHead.DuccHeadTransition.master_to_master;
                    } else {
                        retVal = IDuccHead.DuccHeadTransition.master_to_backup;
                        logger.warn(location, jobid, new Object[]{retVal});
                    }
                } else if (this.isEqual(prev, backup)) {
                    if (this.isEqual(curr, master)) {
                        retVal = IDuccHead.DuccHeadTransition.backup_to_master;
                        logger.warn(location, jobid, new Object[]{retVal});
                    } else {
                        retVal = IDuccHead.DuccHeadTransition.backup_to_backup;
                    }
                } else if (this.isEqual(prev, initial)) {
                    retVal = this.isEqual(curr, master) ? IDuccHead.DuccHeadTransition.master_to_master : (this.isEqual(curr, backup) ? IDuccHead.DuccHeadTransition.backup_to_backup : IDuccHead.DuccHeadTransition.unspecified);
                    logger.info(location, jobid, new Object[]{retVal});
                } else {
                    retVal = IDuccHead.DuccHeadTransition.unspecified;
                }
                logger.debug(location, jobid, new Object[]{retVal, prev, curr});
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        {
            return retVal;
        }
    }
}

