/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi;

import org.apache.uima.ducc.container.common.Assertion;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.fsm.iface.IState;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.Tod;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;

public class WorkItem
implements IWorkItem {
    private static Logger logger = Logger.getLogger(WorkItem.class, IComponent.Id.JD.name());
    private IMetaTask metaCas = null;
    private IFsm fsm = null;
    private Tod todGet = new Tod();
    private Tod todAck = new Tod();
    private Tod todEnd = new Tod();
    private Tod todInvestment = new Tod();

    public WorkItem(IMetaTask metaCas, IFsm fsm) {
        this.setMetaCas(metaCas);
        this.setFsm(fsm);
    }

    @Override
    public void setMetaCas(IMetaTask value) {
        this.metaCas = value;
    }

    @Override
    public IMetaTask getMetaCas() {
        return this.metaCas;
    }

    @Override
    public void setFsm(IFsm value) {
        this.fsm = value;
    }

    @Override
    public IFsm getFsm() {
        return this.fsm;
    }

    @Override
    public void reset() {
        this.metaCas = null;
        this.fsm.reset();
        this.todGet.reset();
        this.todAck.reset();
        this.todEnd.reset();
    }

    @Override
    public void setTodGet() {
        this.todGet.set();
    }

    @Override
    public void resetTodGet() {
        this.todGet.reset();
    }

    @Override
    public long getTodGet() {
        return this.todGet.get();
    }

    @Override
    public void setTodAck() {
        this.todAck.set();
        this.setTodInvestment();
    }

    @Override
    public void resetTodAck() {
        this.todAck.reset();
        this.resetTodInvestment();
    }

    @Override
    public long getTodAck() {
        return this.todAck.get();
    }

    @Override
    public void setTodInvestment() {
        this.todInvestment.set();
    }

    @Override
    public void resetTodInvestment() {
        this.todInvestment.reset();
    }

    @Override
    public long getTodInvestment() {
        return this.todInvestment.get();
    }

    @Override
    public void setTodEnd() {
        this.todEnd.set();
    }

    @Override
    public void resetTodEnd() {
        this.todEnd.reset();
    }

    @Override
    public long getTodEnd() {
        return this.todEnd.get();
    }

    @Override
    public long getMillisOperating() {
        long retVal = 0L;
        long start = this.getTodAck();
        long end = this.getTodEnd();
        if (start > 0L) {
            if (end == 0L) {
                IState state = this.fsm.getStateCurrent();
                end = state.getStateName().equals(WiFsm.CAS_Active.getStateName()) ? System.currentTimeMillis() : start;
            }
            retVal = end - start;
        }
        Assertion.nonNegative(retVal);
        return retVal;
    }

    @Override
    public long getMillisInvestment() {
        long retVal = 0L;
        IState state = this.fsm.getStateCurrent();
        if (state.getStateName().equals(WiFsm.CAS_Active.getStateName())) {
            long now = System.currentTimeMillis();
            retVal = now - this.getTodInvestment();
        }
        Assertion.nonNegative(retVal);
        return retVal;
    }

    @Override
    public int getSeqNo() {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(this.getMetaCas().getSystemKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public int compareTo(Object o) {
        String location = "compareTo";
        int retVal = 0;
        try {
            if (o != null && o instanceof IWorkItem) {
                IWorkItem that = (IWorkItem)o;
                Integer iThis = new Integer(this.getSeqNo());
                Integer iThat = new Integer(that.getSeqNo());
                retVal = iThis.compareTo(iThat);
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public int hashCode() {
        return this.getSeqNo();
    }

    public boolean equals(Object obj) {
        String location = "equals";
        boolean retVal = false;
        try {
            if (obj != null) {
                if (this == obj) {
                    retVal = true;
                } else {
                    IWorkItem that = (IWorkItem)obj;
                    if (this.compareTo(that) == 0) {
                        retVal = true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }
}

