/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.util.Properties;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.cli.aio.CasGenerator;
import org.apache.uima.ducc.cli.aio.CasPipeline;
import org.apache.uima.ducc.user.common.DuccUimaSerializer;

public class AllInOne {
    private static String cid = AllInOne.class.getSimpleName();
    private static DuccUimaSerializer uimaSerializer = new DuccUimaSerializer();
    private MsgHandler mh = new MsgHandler();
    private Properties jobRequestProperties = new Properties();
    private boolean showStats = true;
    static String DriverDescriptorCR = "driver_descriptor_CR";
    static String DriverDescriptorCROverrides = "driver_descriptor_CR_overrides";
    static String ProcessDD = "process_descriptor_DD";
    static String ProcessDescriptorCM = "process_descriptor_CM";
    static String ProcessDescriptorCMOverrides = "process_descriptor_CM_overrides";
    static String ProcessDescriptorAE = "process_descriptor_AE";
    static String ProcessDescriptorAEOverrides = "process_descriptor_AE_overrides";
    static String ProcessDescriptorCC = "process_descriptor_CC";
    static String ProcessDescriptorCCOverrides = "process_descriptor_CC_overrides";
    static String Timestamp = "timestamp";
    static String Debug = "debug";
    CasGenerator casGenerator;
    CasPipeline casPipeline;
    private boolean debug;

    public AllInOne(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (i + 1 < args.length && !args[i + 1].startsWith("--")) {
                this.jobRequestProperties.put(args[i].substring(2), args[i + 1]);
                ++i;
                continue;
            }
            this.jobRequestProperties.put(args[i].substring(2), "");
        }
        this.debug = this.jobRequestProperties.containsKey(Debug);
    }

    private void initialize() throws Exception {
        this.casGenerator = new CasGenerator(this.jobRequestProperties, this.mh);
        this.casGenerator.initialize();
        int total = this.casGenerator.getTotal();
        if (total <= 0) {
            throw new NoWorkItems();
        }
        this.casPipeline = new CasPipeline(this.jobRequestProperties, this.mh);
        this.casPipeline.initialize();
    }

    private void process() throws Exception {
        String mid = "process";
        int count = 0;
        int total = this.casGenerator.getTotal();
        this.mh.frameworkDebug(cid, mid, "total:" + total);
        CAS cas = null;
        while (this.casGenerator.hasNext()) {
            cas = this.casGenerator.getCas(cas);
            this.mh.frameworkDebug(cid, mid, "cas:" + count);
            String serializedCas = uimaSerializer.serializeCasToXmi(cas);
            CAS cas2 = this.casPipeline.getEmptyCas();
            uimaSerializer.deserializeCasFromXmi(serializedCas, cas2);
            this.casPipeline.process(cas2);
            ++count;
        }
        this.casPipeline.destroy();
    }

    private void statistics() {
        if (this.showStats) {
            this.casPipeline.dumpStatistics(System.out);
        }
    }

    public void go() throws Exception {
        try {
            this.initialize();
            this.process();
            this.statistics();
        }
        catch (NoWorkItems e) {
            String message = "no work items";
            System.err.println("AllInOne.go " + message);
        }
    }

    public static void main(String[] args) {
        try {
            AllInOne allInOne = new AllInOne(args);
            allInOne.go();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    class MsgHandler {
        MsgHandler() {
        }

        public void frameworkInfo(String klass, String method, String message) {
            System.out.println(klass + "." + method + " " + message);
        }

        public void frameworkDebug(String klass, String method, String message) {
            if (AllInOne.this.debug) {
                System.out.println(klass + "." + method + " " + message);
            }
        }
    }

    private class NoWorkItems
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoWorkItems() {
        }
    }
}

