/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.AnticompactionRequest;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.SnapshotMessage;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.repair.messages.ValidationRequest;

public abstract class RepairMessage {
    public static final IVersionedSerializer<RepairMessage> serializer = new RepairMessageSerializer();
    public final Type messageType;
    public final RepairJobDesc desc;

    protected RepairMessage(Type messageType, RepairJobDesc desc) {
        this.messageType = messageType;
        this.desc = desc;
    }

    public MessageOut<RepairMessage> createMessage() {
        return new MessageOut<RepairMessage>(MessagingService.Verb.REPAIR_MESSAGE, this, serializer);
    }

    public static class RepairMessageSerializer
    implements MessageSerializer<RepairMessage> {
        @Override
        public void serialize(RepairMessage message, DataOutputPlus out, int version) throws IOException {
            out.write(message.messageType.type);
            message.messageType.serializer.serialize(message, out, version);
        }

        @Override
        public RepairMessage deserialize(DataInputPlus in, int version) throws IOException {
            Type messageType = Type.fromByte(in.readByte());
            return (RepairMessage)messageType.serializer.deserialize(in, version);
        }

        @Override
        public long serializedSize(RepairMessage message, int version) {
            long size = 1L;
            return size += message.messageType.serializer.serializedSize(message, version);
        }
    }

    public static enum Type {
        VALIDATION_REQUEST(0, ValidationRequest.serializer),
        VALIDATION_COMPLETE(1, ValidationComplete.serializer),
        SYNC_REQUEST(2, SyncRequest.serializer),
        SYNC_COMPLETE(3, SyncComplete.serializer),
        ANTICOMPACTION_REQUEST(4, AnticompactionRequest.serializer),
        PREPARE_MESSAGE(5, PrepareMessage.serializer),
        SNAPSHOT(6, SnapshotMessage.serializer),
        CLEANUP(7, CleanupMessage.serializer);

        private final byte type;
        private final MessageSerializer<RepairMessage> serializer;

        private Type(int type, MessageSerializer<RepairMessage> serializer) {
            this.type = (byte)type;
            this.serializer = serializer;
        }

        public static Type fromByte(byte b) {
            for (Type t : Type.values()) {
                if (t.type != b) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown RepairMessage.Type: " + b);
        }
    }

    public static interface MessageSerializer<T extends RepairMessage>
    extends IVersionedSerializer<T> {
    }
}

