/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.internal.util.Utilities;

public class UIMAClassLoader
extends URLClassLoader {
    private static final int nbrLocks;
    private final Object[] syncLocks = new Object[nbrLocks];

    public static URL[] transformClasspath(String classpath) throws MalformedURLException {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            pathList.add(tok.nextToken());
        }
        int max = pathList.size();
        URL[] urlArray = new URL[max];
        for (int i = 0; i < max; ++i) {
            urlArray[i] = new File((String)pathList.get(i)).toURI().toURL();
        }
        return urlArray;
    }

    public UIMAClassLoader(String classpath) throws MalformedURLException {
        super(UIMAClassLoader.transformClasspath(classpath));
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath) {
        super(classpath);
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.commonInit();
    }

    public UIMAClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        super(UIMAClassLoader.transformClasspath(classpath), parent);
        this.commonInit();
    }

    private void commonInit() {
        for (int i = 0; i < nbrLocks; ++i) {
            this.syncLocks[i] = new Object();
        }
    }

    public static URLClassLoader newInstance(URL[] urls) {
        throw new UnsupportedOperationException();
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, false);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (null == url) {
            url = super.getResource(name);
        }
        return url;
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            System.err.println("WARNING - Failed to register the UIMA Class loader as parallel-capable - should never happen");
        }
        nbrLocks = Utilities.nextHigherPowerOf2(Runtime.getRuntime().availableProcessors());
    }
}

