/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.dict_annot.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.uima.annotator.dict_annot.dictionary.impl.FeaturePathInfo;
import org.apache.uima.annotator.dict_annot.impl.Condition;
import org.apache.uima.annotator.dict_annot.impl.DictionaryAnnotatorConfigException;
import org.apache.uima.annotator.dict_annot.impl.DictionaryAnnotatorProcessException;
import org.apache.uima.annotator.dict_annot.impl.FilterOp;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.cas.text.AnnotationFS;

public class FeaturePathInfo_impl
implements FeaturePathInfo {
    private String featurePathString;
    private ArrayList<String> featurePathElementNames = new ArrayList();
    private ArrayList<Feature> featurePathElements = null;

    public void initialize(String featurePath) throws DictionaryAnnotatorConfigException {
        this.featurePathString = featurePath;
        if (this.featurePathString.indexOf("//") > -1) {
            throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_invalid_feature_path_syntax", new Object[]{this.featurePathString, "//"});
        }
        StringTokenizer tokenizer = new StringTokenizer(this.featurePathString, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            this.featurePathElementNames.add(token);
        }
    }

    public void typeSystemInit(Type featurePathType) throws DictionaryAnnotatorProcessException {
        TypeSystemUtils.PathValid pathValid = TypeSystemUtils.isPathValid((Type)featurePathType, this.featurePathElementNames);
        if (TypeSystemUtils.PathValid.NEVER == pathValid) {
            throw new DictionaryAnnotatorProcessException("dictionary_annotator_error_validating_feature_path", new Object[]{this.featurePathString, featurePathType.getName()});
        }
        if (TypeSystemUtils.PathValid.ALWAYS == pathValid) {
            this.featurePathElements = new ArrayList();
            Type currentType = featurePathType;
            for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
                Feature feature = currentType.getFeatureByBaseName(this.featurePathElementNames.get(i));
                this.featurePathElements.add(feature);
                currentType = feature.getRange();
            }
        }
    }

    public String getValue(AnnotationFS annotFS) {
        if (this.featurePathElementNames.size() == 0) {
            return annotFS.getCoveredText();
        }
        String featurePathValue = null;
        boolean noFurtherElementsPossible = false;
        AnnotationFS currentFS = annotFS;
        Type currentType = annotFS.getType();
        int currentFeatureTypeCode = 0;
        block12: for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
            if (noFurtherElementsPossible) {
                return null;
            }
            Feature feature = this.featurePathElements == null ? currentType.getFeatureByBaseName(this.featurePathElementNames.get(i)) : this.featurePathElements.get(i);
            if (feature == null) {
                return null;
            }
            Type featureType = feature.getRange();
            currentFeatureTypeCode = TypeSystemUtils.classifyType((Type)featureType);
            switch (currentFeatureTypeCode) {
                case 3: {
                    featurePathValue = currentFS.getStringValue(feature);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 1: {
                    featurePathValue = Integer.toString(currentFS.getIntValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 9: {
                    featurePathValue = Boolean.toString(currentFS.getBooleanValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 10: {
                    featurePathValue = Byte.toString(currentFS.getByteValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 13: {
                    featurePathValue = Double.toString(currentFS.getDoubleValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 2: {
                    featurePathValue = Float.toString(currentFS.getFloatValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 12: {
                    featurePathValue = Long.toString(currentFS.getLongValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 0: {
                    featurePathValue = null;
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 11: {
                    featurePathValue = Short.toString(currentFS.getShortValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 8: {
                    currentFS = currentFS.getFeatureValue(feature);
                    if (currentFS == null) {
                        noFurtherElementsPossible = true;
                        featurePathValue = null;
                        continue block12;
                    }
                    currentType = currentFS.getType();
                    continue block12;
                }
                default: {
                    ResourceBundle bundle = ResourceBundle.getBundle("org.apache.uima.annotator.dict_annot.dictionaryAnnotatorMessages", Locale.getDefault(), this.getClass().getClassLoader());
                    String rawMessage = bundle.getString("dictionary_annotator_error_feature_path_element_not_supported");
                    MessageFormat messageFormat = new MessageFormat(rawMessage);
                    messageFormat.setLocale(Locale.getDefault());
                    String message = messageFormat.format(new Object[]{currentType.getName(), this.featurePathElementNames.get(i), this.featurePathString});
                    throw new RuntimeException(message);
                }
            }
        }
        if (featurePathValue != null) {
            return featurePathValue;
        }
        if (currentFS != null && currentFeatureTypeCode == 8 && currentFS instanceof AnnotationFS) {
            return currentFS.getCoveredText();
        }
        return null;
    }

    public String getFeaturePath() {
        return this.featurePathString;
    }

    public boolean match(AnnotationFS annotFS, Condition condition) {
        if (this.featurePathElementNames.size() == 0) {
            return false;
        }
        boolean noFurtherElementsPossible = false;
        boolean checkCondidtion = false;
        AnnotationFS currentFS = annotFS;
        Type currentType = annotFS.getType();
        int currentFeatureTypeCode = 0;
        block12: for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
            if (noFurtherElementsPossible) {
                return false;
            }
            Feature feature = this.featurePathElements == null ? currentType.getFeatureByBaseName(this.featurePathElementNames.get(i)) : this.featurePathElements.get(i);
            if (feature == null) {
                return false;
            }
            Type featureType = feature.getRange();
            currentFeatureTypeCode = TypeSystemUtils.classifyType((Type)featureType);
            switch (currentFeatureTypeCode) {
                case 3: {
                    checkCondidtion = this.checkString(annotFS.getStringValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 1: {
                    checkCondidtion = this.checkInt(annotFS.getIntValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 9: {
                    checkCondidtion = this.checkBoolean(annotFS.getBooleanValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 10: {
                    checkCondidtion = this.checkByte(annotFS.getByteValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 13: {
                    checkCondidtion = this.checkDouble(annotFS.getDoubleValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 2: {
                    checkCondidtion = this.checkFloat(annotFS.getFloatValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 12: {
                    checkCondidtion = this.checkLong(annotFS.getLongValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 0: {
                    noFurtherElementsPossible = true;
                    checkCondidtion = false;
                    continue block12;
                }
                case 11: {
                    checkCondidtion = this.checkShort(annotFS.getShortValue(feature), condition);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 8: {
                    currentFS = currentFS.getFeatureValue(feature);
                    if (currentFS == null) {
                        noFurtherElementsPossible = true;
                        checkCondidtion = false;
                        continue block12;
                    }
                    currentType = currentFS.getType();
                    continue block12;
                }
                default: {
                    ResourceBundle bundle = ResourceBundle.getBundle("org.apache.uima.annotator.dict_annot.dictionaryAnnotatorMessages", Locale.getDefault(), this.getClass().getClassLoader());
                    String rawMessage = bundle.getString("dictionary_annotator_error_feature_path_element_not_supported");
                    MessageFormat messageFormat = new MessageFormat(rawMessage);
                    messageFormat.setLocale(Locale.getDefault());
                    String message = messageFormat.format(new Object[]{currentType.getName(), this.featurePathElementNames.get(i), this.featurePathString});
                    throw new RuntimeException(message);
                }
            }
        }
        return checkCondidtion;
    }

    private final boolean checkByte(byte in, Condition condition) {
        byte v;
        String value = condition.getValue();
        try {
            v = Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkDouble(double in, Condition condition) {
        double v;
        String value = condition.getValue();
        try {
            v = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkFloat(float in, Condition condition) {
        float v;
        String value = condition.getValue();
        try {
            v = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkLong(long in, Condition condition) {
        long v;
        String value = condition.getValue();
        try {
            v = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkInt(int in, Condition condition) {
        int v;
        String value = condition.getValue();
        try {
            v = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkShort(short in, Condition condition) {
        short v;
        String value = condition.getValue();
        try {
            v = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (condition.getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkString(String s, Condition condition) {
        String value = condition.getValue();
        assert (value != null);
        FilterOp op = condition.getConditionType();
        switch (op) {
            case NULL: {
                return s == null;
            }
            case NOT_NULL: {
                return s != null;
            }
        }
        if (s == null) {
            return false;
        }
        int comp = s.compareTo(value);
        switch (op) {
            case EQUALS: {
                return comp == 0;
            }
            case NOT_EQUALS: {
                return comp != 0;
            }
            case GREATER: {
                return comp > 0;
            }
            case GREATER_EQ: {
                return comp >= 0;
            }
            case LESS: {
                return comp < 0;
            }
            case LESS_EQ: {
                return comp <= 0;
            }
        }
        return false;
    }

    private final boolean checkBoolean(boolean b, Condition condition) {
        String value = condition.getValue();
        boolean v = Boolean.parseBoolean(value);
        switch (condition.getConditionType()) {
            case EQUALS: {
                return v == b;
            }
            case NOT_EQUALS: {
                return v != b;
            }
        }
        return false;
    }
}

