/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tika;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tika.TIKAWrapper;
import org.apache.uima.util.Level;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FileSystemCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_LANGUAGE = "Language";
    private static final String PARAM_MIME = "MIME";
    private static final String tika_file_param = "tikaConfigFile";
    private String mLanguage;
    private String mMIME;
    private List<File> mFiles;
    private int mCurrentIndex;
    private TIKAWrapper tika;

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        try {
            JCas jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        File file = this.mFiles.get(this.mCurrentIndex++);
        try {
            this.tika.populateCASfromURL(aCAS, file.toURI().toURL(), this.mMIME, this.mLanguage);
        }
        catch (CASException e) {
            String msg = String.format("Problem converting file: %s\t%s%n", file.toURI().toURL(), e.getMessage());
            this.getLogger().log(Level.WARNING, msg);
            throw new IOException(msg);
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mFiles.size();
    }

    public void initialize() throws ResourceInitializationException {
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mCurrentIndex = 0;
        this.mMIME = (String)this.getConfigParameterValue(PARAM_MIME);
        String tikaConfigURL = (String)this.getConfigParameterValue(tika_file_param);
        try {
            this.tika = new TIKAWrapper(tikaConfigURL);
        }
        catch (TikaException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList<File>();
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            this.mFiles.add(files[i]);
        }
    }
}

