/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.solrcas;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.solrcas.SolrMappingConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FieldMappingReader {
    public SolrMappingConfiguration getConf(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        FieldMappingHandler handler = new FieldMappingHandler();
        parser.parse(input, (DefaultHandler)handler);
        Map<String, Map<String, String>> fieldMapping = handler.getFieldMapping();
        String documentText = handler.getDocumentText();
        String documentLanguage = handler.getDocumentLanguage();
        input.close();
        SolrMappingConfiguration solrMappingConfiguration = new SolrMappingConfiguration(documentText, documentLanguage, fieldMapping);
        return solrMappingConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldMappingHandler
    extends DefaultHandler {
        private Map<String, Map<String, String>> fieldMapping;
        private String type;
        private Map<String, String> mapping;
        private String documentText;
        private String documentLanguage;
        private boolean inLang = false;
        private boolean inText = false;
        private static final String TYPE = "type";
        private static final String MAP = "map";
        private static final String TEXT = "documentText";
        private static final String LANGUAGE = "documentLanguage";
        private static final String MAPPING = "solrMapping";

        private FieldMappingHandler() {
        }

        public Map<String, Map<String, String>> getFieldMapping() {
            return this.fieldMapping;
        }

        public String getDocumentText() {
            return this.documentText;
        }

        public String getDocumentLanguage() {
            return this.documentLanguage;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (MAPPING.equals(name)) {
                this.fieldMapping = new HashMap<String, Map<String, String>>();
            } else if (TYPE.equals(name)) {
                this.type = attributes.getValue("name");
                this.mapping = new HashMap<String, String>();
            } else if (MAP.equals(name)) {
                String feature = attributes.getValue("feature");
                String field = attributes.getValue("field");
                this.mapping.put(feature, field);
            } else if (LANGUAGE.equals(name)) {
                this.inLang = true;
            } else if (TEXT.equals(name)) {
                this.inText = true;
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.inText) {
                this.documentText = String.valueOf(chars, start, length);
            } else if (this.inLang) {
                this.documentLanguage = String.valueOf(chars, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (!MAP.equals(name)) {
                if (TYPE.equals(name)) {
                    this.fieldMapping.put(this.type, this.mapping);
                } else if (LANGUAGE.equals(name)) {
                    this.inLang = false;
                } else if (TEXT.equals(name)) {
                    this.inText = false;
                }
            }
        }
    }
}

