/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.config.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.simpleserver.SimpleServerException;
import org.apache.uima.simpleserver.config.AndFilter;
import org.apache.uima.simpleserver.config.Condition;
import org.apache.uima.simpleserver.config.ConfigFactory;
import org.apache.uima.simpleserver.config.Filter;
import org.apache.uima.simpleserver.config.FilterOp;
import org.apache.uima.simpleserver.config.OrFilter;
import org.apache.uima.simpleserver.config.Output;
import org.apache.uima.simpleserver.config.ServerSpec;
import org.apache.uima.simpleserver.config.SimpleFilter;
import org.apache.uima.simpleserver.config.TypeMap;
import org.apache.uima.simpleserver.config.xml.And;
import org.apache.uima.simpleserver.config.xml.FilterOperator;
import org.apache.uima.simpleserver.config.xml.FilterType;
import org.apache.uima.simpleserver.config.xml.Or;
import org.apache.uima.simpleserver.config.xml.OutputType;
import org.apache.uima.simpleserver.config.xml.SimpleFilterType;
import org.apache.uima.simpleserver.config.xml.TypeElementType;
import org.apache.uima.simpleserver.config.xml.UimaSimpleServerSpecDocument;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlConfigReader {
    private static final int NULL = FilterOperator.Enum.forString("null").intValue();
    private static final int NOT_NULL = FilterOperator.Enum.forString("!null").intValue();
    private static final int EQUALS = FilterOperator.Enum.forString("=").intValue();
    private static final int NOT_EQUALS = FilterOperator.Enum.forString("!=").intValue();
    private static final int LESS = FilterOperator.Enum.forString("<").intValue();
    private static final int LESS_EQ = FilterOperator.Enum.forString("<=").intValue();
    private static final int GREATER = FilterOperator.Enum.forString(">").intValue();
    private static final int GREATER_EQ = FilterOperator.Enum.forString(">=").intValue();

    public static ServerSpec readServerSpec(File file) throws IOException, XmlException, SimpleServerException {
        return XmlConfigReader.readServerSpec(new BufferedInputStream(new FileInputStream(file)));
    }

    public static ServerSpec readServerSpec(InputStream is) throws IOException, XmlException, SimpleServerException {
        Iterator iter;
        UimaSimpleServerSpecDocument.UimaSimpleServerSpec specBean = UimaSimpleServerSpecDocument.Factory.parse(is).getUimaSimpleServerSpec();
        ArrayList validationErrors = new ArrayList();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = specBean.validate(validationOptions);
        if (!isValid && (iter = validationErrors.iterator()).hasNext()) {
            throw new XmlException((XmlError)iter.next());
        }
        boolean doOutputAll = false;
        ServerSpec spec = ConfigFactory.newServerSpec(specBean.getShortDescription(), specBean.getLongDescription(), false);
        TypeElementType[] typeMaps = specBean.getTypeArray();
        for (int i = 0; i < typeMaps.length; ++i) {
            spec.addTypeMap(XmlConfigReader.readTypeMap(typeMaps[i]));
        }
        return spec;
    }

    private static TypeMap readTypeMap(TypeElementType typeBean) throws SimpleServerException {
        boolean coveredText = typeBean.getOutputCoveredText();
        Filter filter = null;
        if (typeBean.getFilters() != null) {
            TypeElementType.Filters filterBean = typeBean.getFilters();
            if (filterBean.getAnd() != null) {
                filter = XmlConfigReader.readFilter(filterBean.getAnd());
            } else if (filterBean.getOr() != null) {
                filter = XmlConfigReader.readFilter(filterBean.getOr());
            } else if (filterBean.getFilter() != null) {
                filter = XmlConfigReader.readFilter(filterBean.getFilter());
            }
        }
        TypeMap typeMap = ConfigFactory.newTypeMap(typeBean.getName(), filter, typeBean.getOutputTag(), coveredText, typeBean.getOutputAll(), typeBean.getShortDescription(), typeBean.getLongDescription());
        if (typeBean.getOutputs() != null) {
            TypeElementType.Outputs outputBean = typeBean.getOutputs();
            OutputType[] outputTypes = outputBean.getOutputArray();
            for (int i = 0; i < outputTypes.length; ++i) {
                List<String> featurePath = XmlConfigReader.parseFeaturePath(outputTypes[i].getFeaturePath());
                Output output = ConfigFactory.newOutput(featurePath, outputTypes[i].getOutputAttribute(), outputTypes[i].getShortDescription(), outputTypes[i].getLongDescription());
                typeMap.addOutput(output);
            }
        }
        return typeMap;
    }

    private static final Filter readFilter(FilterType filterBean) throws SimpleServerException {
        Filter filter = null;
        filter = filterBean instanceof And ? XmlConfigReader.readAndFilter((And)filterBean) : (filterBean instanceof Or ? XmlConfigReader.readOrFilter((Or)filterBean) : XmlConfigReader.readSimpleFilter((SimpleFilterType)filterBean));
        return filter;
    }

    private static final AndFilter readAndFilter(And filterBean) throws SimpleServerException {
        AndFilter filter = ConfigFactory.newAndFilter();
        SimpleFilterType[] simpleFilters = filterBean.getFilterArray();
        And[] andBeans = filterBean.getAndArray();
        Or[] orBeans = filterBean.getOrArray();
        List<FilterType> filterBeans = XmlConfigReader.getFilters(simpleFilters, andBeans, orBeans);
        for (int i = 0; i < filterBeans.size(); ++i) {
            filter.addFilter(XmlConfigReader.readFilter(filterBeans.get(i)));
        }
        return filter;
    }

    private static final List<FilterType> getFilters(SimpleFilterType[] simpleFilters, And[] andBeans, Or[] orBeans) {
        int i;
        ArrayList<FilterType> list = new ArrayList<FilterType>();
        for (i = 0; i < simpleFilters.length; ++i) {
            list.add(simpleFilters[i]);
        }
        for (i = 0; i < andBeans.length; ++i) {
            list.add(andBeans[i]);
        }
        for (i = 0; i < orBeans.length; ++i) {
            list.add(orBeans[i]);
        }
        return list;
    }

    private static final OrFilter readOrFilter(Or filterBean) throws SimpleServerException {
        OrFilter filter = ConfigFactory.newOrFilter();
        SimpleFilterType[] simpleFilters = filterBean.getFilterArray();
        And[] andBeans = filterBean.getAndArray();
        Or[] orBeans = filterBean.getOrArray();
        List<FilterType> filterBeans = XmlConfigReader.getFilters(simpleFilters, andBeans, orBeans);
        for (int i = 0; i < filterBeans.size(); ++i) {
            filter.addFilter(XmlConfigReader.readFilter(filterBeans.get(i)));
        }
        return filter;
    }

    private static final SimpleFilter readSimpleFilter(SimpleFilterType filterBean) throws SimpleServerException {
        List<String> path = XmlConfigReader.parseFeaturePath(filterBean.getFeaturePath());
        Condition condition = XmlConfigReader.readCondition(filterBean.getOperator(), filterBean.getValue());
        return ConfigFactory.newSimpleFilter(path, condition);
    }

    private static final Condition readCondition(FilterOperator.Enum operator, String value) throws SimpleServerException {
        FilterOp op = XmlConfigReader.readOperator(operator);
        XmlConfigReader.checkCondition(op, value);
        return ConfigFactory.newCondition(op, value);
    }

    private static final void checkCondition(FilterOp op, String value) throws SimpleServerException {
        switch (op) {
            case NOT_NULL: 
            case NULL: {
                XmlConfigReader.valueMustBeNull(op, value);
                break;
            }
            default: {
                XmlConfigReader.valueMustNotBeNull(op, value);
            }
        }
    }

    private static final void valueMustBeNull(FilterOp op, String value) throws SimpleServerException {
        if (value != null) {
            throw new SimpleServerException("value_must_not_be_set", new Object[]{op, value});
        }
    }

    private static final void valueMustNotBeNull(FilterOp op, String value) throws SimpleServerException {
        if (value == null) {
            throw new SimpleServerException("value_must_be_set", new Object[]{op});
        }
    }

    private static final FilterOp readOperator(FilterOperator.Enum operator) {
        int op = operator.intValue();
        if (op == NULL) {
            return FilterOp.NULL;
        }
        if (op == NOT_NULL) {
            return FilterOp.NOT_NULL;
        }
        if (op == EQUALS) {
            return FilterOp.EQUALS;
        }
        if (op == NOT_EQUALS) {
            return FilterOp.NOT_EQUALS;
        }
        if (op == LESS) {
            return FilterOp.LESS;
        }
        if (op == LESS_EQ) {
            return FilterOp.LESS_EQ;
        }
        if (op == GREATER) {
            return FilterOp.GREATER;
        }
        if (op == GREATER_EQ) {
            return FilterOp.GREATER_EQ;
        }
        assert (false);
        return null;
    }

    private static List<String> parseFeaturePath(String path) throws SimpleServerException {
        ArrayList<String> featureList = new ArrayList<String>();
        int max = path.length();
        int pos = 0;
        if (max > 0 && path.charAt(0) == '/') {
            pos = 1;
        }
        while (pos < max) {
            int next;
            for (next = pos; next < max && path.charAt(next) != '/'; ++next) {
            }
            if (next < max && next == pos) {
                throw new SimpleServerException("incorrect_path_syntax", new Object[]{path});
            }
            String feature = path.substring(pos, next);
            if (!TypeSystemUtils.isIdentifier((String)feature)) {
                throw new SimpleServerException("incorrect_feature_syntax", new Object[]{feature, path});
            }
            featureList.add(feature);
            pos = next + 1;
        }
        return featureList;
    }
}

