/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.config.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.simpleserver.SimpleServerException;
import org.apache.uima.simpleserver.config.AndFilter;
import org.apache.uima.simpleserver.config.Filter;
import org.apache.uima.simpleserver.config.OrFilter;
import org.apache.uima.simpleserver.config.Output;
import org.apache.uima.simpleserver.config.ServerSpec;
import org.apache.uima.simpleserver.config.SimpleFilter;
import org.apache.uima.simpleserver.config.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSpecImpl
implements ServerSpec {
    private final String shortDescription;
    private final String longDescription;
    private final boolean doOutputAll;
    private final List<TypeMap> typeMaps = new ArrayList<TypeMap>();

    public ServerSpecImpl(String shortDesc, String longDesc, boolean doOutputAll) {
        this.shortDescription = shortDesc;
        this.longDescription = longDesc;
        this.doOutputAll = doOutputAll;
    }

    public ServerSpecImpl(String shortDesc, String longDesc) {
        this(shortDesc, longDesc, false);
    }

    @Override
    public void addTypeMap(TypeMap typeMap) {
        this.typeMaps.add(typeMap);
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public List<TypeMap> getTypeSpecs() {
        return this.typeMaps;
    }

    @Override
    public List<SimpleServerException> validate(TypeSystem typeSystem) {
        ArrayList<SimpleServerException> exc = new ArrayList<SimpleServerException>();
        List<TypeMap> typeSpecs = this.getTypeSpecs();
        for (TypeMap typeMap : typeSpecs) {
            Type type = typeSystem.getType(typeMap.getTypeName());
            if (type == null) {
                exc.add(new SimpleServerException("type_does_not_exist", new Object[]{typeMap.getTypeName()}));
                continue;
            }
            Filter filter = typeMap.getFilter();
            if (filter != null) {
                ServerSpecImpl.checkFilter(filter, type, exc);
            }
            ServerSpecImpl.checkOutputs(typeMap.getOutputs(), type, exc);
        }
        return exc;
    }

    private static final void checkOutputs(List<Output> outputs, Type type, List<SimpleServerException> exc) {
        for (Output output : outputs) {
            List<String> fPath = output.getFeaturePath();
            if (TypeSystemUtils.isPathValid((Type)type, fPath) != TypeSystemUtils.PathValid.NEVER) continue;
            exc.add(new SimpleServerException("path_never_valid", new Object[]{ServerSpecImpl.fPathToString(fPath), type}));
        }
    }

    private static final void checkFilter(Filter filter, Type type, List<SimpleServerException> exc) {
        Filter.FilterType filterType = filter.getFilterType();
        switch (filterType) {
            case AND: {
                ServerSpecImpl.checkFilters(((AndFilter)filter).getFilters(), type, exc);
                break;
            }
            case OR: {
                ServerSpecImpl.checkFilters(((OrFilter)filter).getFilters(), type, exc);
                break;
            }
            case SIMPLE: {
                List<String> fPath = ((SimpleFilter)filter).getFeaturePath();
                if (TypeSystemUtils.isPathValid((Type)type, fPath) != TypeSystemUtils.PathValid.NEVER) break;
                exc.add(new SimpleServerException("path_never_valid", new Object[]{ServerSpecImpl.fPathToString(fPath), type}));
                break;
            }
        }
    }

    private static final String fPathToString(List<String> fPath) {
        StringBuffer buf = new StringBuffer();
        buf.append('/');
        for (String f : fPath) {
            buf.append(f);
            buf.append('/');
        }
        return buf.toString();
    }

    private static final void checkFilters(List<Filter> filters, Type type, List<SimpleServerException> exc) {
        for (Filter filter : filters) {
            ServerSpecImpl.checkFilter(filter, type, exc);
        }
    }

    @Override
    public boolean getOutputAll() {
        return this.doOutputAll;
    }
}

