/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.simpleserver.config.ConfigFactory;
import org.apache.uima.simpleserver.config.Filter;
import org.apache.uima.simpleserver.config.Output;
import org.apache.uima.simpleserver.config.ServerSpec;
import org.apache.uima.simpleserver.config.TypeMap;
import org.apache.uima.simpleserver.output.Result;
import org.apache.uima.simpleserver.output.ResultEntry;
import org.apache.uima.simpleserver.output.impl.ResultEntryImpl;
import org.apache.uima.simpleserver.output.impl.ResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultExtractor {
    private TypeSystem ts = null;
    private DefaultTypeMap defaultTypeMap = null;

    public Result getResult(CAS cas, ServerSpec resultSpec) {
        ArrayList<ResultEntry> resultEntries = new ArrayList<ResultEntry>();
        this.processTypes(cas, resultSpec, resultEntries);
        return new ResultImpl(resultEntries, cas.getDocumentText());
    }

    private void processTypes(CAS cas, ServerSpec rspec, List<ResultEntry> resultEntries) {
        if (rspec.getOutputAll()) {
            this.outputAll(cas, resultEntries);
            return;
        }
        Type annotationType = cas.getTypeSystem().getType("uima.tcas.Annotation");
        for (TypeMap tspec : rspec.getTypeSpecs()) {
            TypeSystem typeSystem = cas.getTypeSystem();
            Type type = typeSystem.getType(tspec.getTypeName());
            if (type == null || !typeSystem.subsumes(annotationType, type)) continue;
            FSIterator iterator = cas.getAnnotationIndex(type).iterator();
            while (iterator.isValid()) {
                AnnotationFS annotation = (AnnotationFS)iterator.get();
                Filter filter = tspec.getFilter();
                if (filter == null || filter.match((FeatureStructure)annotation)) {
                    ResultEntryImpl resultEntry = new ResultEntryImpl(tspec.getOutputTag(), annotation.getBegin(), annotation.getEnd());
                    ResultExtractor.makeOutputs(resultEntry, annotation, tspec);
                    resultEntries.add(resultEntry);
                }
                iterator.moveToNext();
            }
        }
    }

    private void outputAll(CAS cas, List<ResultEntry> resultEntries) {
        this.checkCreateDefaultMap(cas.getTypeSystem());
        Type docAnnotationType = cas.getTypeSystem().getType("uima.tcas.DocumentAnnotation");
        FSIterator it = cas.getAnnotationIndex().iterator();
        it.moveToFirst();
        while (it.isValid()) {
            AnnotationFS annot = (AnnotationFS)it.get();
            if (!annot.getType().equals(docAnnotationType)) {
                TypeMap typeMap = this.defaultTypeMap.get(annot.getType());
                ResultEntryImpl resultEntry = new ResultEntryImpl(typeMap.getOutputTag(), annot.getBegin(), annot.getEnd());
                ResultExtractor.makeOutputs(resultEntry, annot, typeMap);
                resultEntries.add(resultEntry);
            }
            it.moveToNext();
        }
    }

    private final void checkCreateDefaultMap(TypeSystem typeSystem) {
        assert (typeSystem != null);
        if (typeSystem == this.ts) {
            return;
        }
        this.ts = typeSystem;
        DefaultTypeMap dtm = new DefaultTypeMap();
        dtm.initialize(typeSystem);
        this.defaultTypeMap = dtm;
    }

    public static void makeOutputs(ResultEntryImpl resultEntry, AnnotationFS annotation, TypeMap tspec) {
        if (tspec.isOutputCoveredText()) {
            resultEntry.setCoveredText(annotation.getCoveredText());
        }
        for (Output outSpec : tspec.getOutputs()) {
            String value = ResultExtractor.evaluatePath((FeatureStructure)annotation, outSpec.getFeaturePath());
            if (value == null) continue;
            String stringValue = value.toString();
            resultEntry.setAttributeValue(outSpec.getAttribute(), stringValue);
        }
    }

    private static final String evaluatePath(FeatureStructure fs, List<String> path) {
        for (int i = 0; i < path.size(); ++i) {
            String f = path.get(i);
            Feature feat = fs.getType().getFeatureByBaseName(f);
            if (feat == null) {
                return null;
            }
            int typeClass = TypeSystemUtils.classifyType((Type)feat.getRange());
            if (typeClass == 8) {
                if ((fs = fs.getFeatureValue(feat)) != null) continue;
                return null;
            }
            if (i == path.size() - 1) {
                return fs.getFeatureValueAsString(feat);
            }
            return null;
        }
        return fs.toString();
    }

    private static class DefaultTypeMap {
        private final Map<Type, TypeMap> typeMap = new HashMap<Type, TypeMap>();

        private DefaultTypeMap() {
        }

        private void initialize(TypeSystem ts) {
            Type annotationType = ts.getType("uima.tcas.Annotation");
            List annotationTypes = ts.getProperlySubsumedTypes(annotationType);
            annotationTypes.add(annotationType);
            for (Type type : annotationTypes) {
                this.createMapForType(type);
            }
        }

        private void createMapForType(Type type) {
            TypeMap tm = ConfigFactory.newTypeMap(type.getName(), null, type.getShortName(), true);
            for (Feature feat : type.getFeatures()) {
                if (!feat.getRange().isPrimitive()) continue;
                ArrayList<String> path = new ArrayList<String>(1);
                path.add(feat.getShortName());
                Output out = ConfigFactory.newOutput(path, feat.getShortName(), "No description provided", "No description provided");
                tm.addOutput(out);
            }
            this.typeMap.put(type, tm);
        }

        private TypeMap get(Type type) {
            return this.typeMap.get(type);
        }
    }
}

