/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.annotator.regex.FeaturePath;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.cas.text.AnnotationFS;

public class FeaturePath_impl
implements FeaturePath {
    private String featurePathString;
    private ArrayList<String> featurePathElementNames;
    private ArrayList<Feature> featurePathElements;

    public FeaturePath_impl(String featurePath) {
        this.featurePathString = featurePath;
        this.featurePathElementNames = new ArrayList();
        this.featurePathElements = null;
    }

    public void initialize(Type type) throws RegexAnnotatorConfigException {
        if (this.featurePathString != null) {
            if (this.featurePathString.indexOf("//") > -1) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_invalid_feature_path_syntax", new Object[]{this.featurePathString, "//"});
            }
            StringTokenizer tokenizer = new StringTokenizer(this.featurePathString, "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.featurePathElementNames.add(token);
            }
            TypeSystemUtils.PathValid pathValid = TypeSystemUtils.isPathValid((Type)type, this.featurePathElementNames);
            if (TypeSystemUtils.PathValid.NEVER == pathValid) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_validating_feature_path", new Object[]{this.featurePathString, type.getName()});
            }
            if (TypeSystemUtils.PathValid.ALWAYS == pathValid) {
                this.featurePathElements = new ArrayList();
                Type currentType = type;
                for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
                    Feature feature = currentType.getFeatureByBaseName(this.featurePathElementNames.get(i));
                    this.featurePathElements.add(feature);
                    currentType = feature.getRange();
                }
            }
        }
    }

    public String getValue(AnnotationFS annotFS) throws RegexAnnotatorProcessException {
        if (this.featurePathElementNames.size() == 0) {
            return annotFS.getCoveredText();
        }
        String featurePathValue = null;
        boolean noFurtherElementsPossible = false;
        AnnotationFS currentFS = annotFS;
        Type currentType = annotFS.getType();
        block12: for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
            if (noFurtherElementsPossible) {
                return null;
            }
            Feature feature = this.featurePathElements == null ? currentType.getFeatureByBaseName(this.featurePathElementNames.get(i)) : this.featurePathElements.get(i);
            if (feature == null) {
                return null;
            }
            Type featureType = feature.getRange();
            int featureTypeCode = TypeSystemUtils.classifyType((Type)featureType);
            switch (featureTypeCode) {
                case 3: {
                    featurePathValue = currentFS.getStringValue(feature);
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 1: {
                    featurePathValue = Integer.toString(currentFS.getIntValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 9: {
                    featurePathValue = Boolean.toString(currentFS.getBooleanValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 10: {
                    featurePathValue = Byte.toString(currentFS.getByteValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 13: {
                    featurePathValue = Double.toString(currentFS.getDoubleValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 2: {
                    featurePathValue = Float.toString(currentFS.getFloatValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 12: {
                    featurePathValue = Long.toString(currentFS.getLongValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 0: {
                    featurePathValue = null;
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 11: {
                    featurePathValue = Short.toString(currentFS.getShortValue(feature));
                    noFurtherElementsPossible = true;
                    continue block12;
                }
                case 8: {
                    currentFS = currentFS.getFeatureValue(feature);
                    if (currentFS == null) {
                        noFurtherElementsPossible = true;
                        featurePathValue = null;
                        continue block12;
                    }
                    currentType = currentFS.getType();
                    continue block12;
                }
                default: {
                    throw new RegexAnnotatorProcessException("regex_annotator_error_feature_path_element_not_supported", new Object[]{currentType.getName(), this.featurePathElementNames.get(i), this.featurePathString});
                }
            }
        }
        if (featurePathValue != null) {
            return featurePathValue;
        }
        if (currentFS != null && currentFS instanceof AnnotationFS) {
            return currentFS.getCoveredText();
        }
        return null;
    }

    public String getFeaturePath() {
        return this.featurePathString;
    }
}

