/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.uima.annotator.regex.Annotation;
import org.apache.uima.annotator.regex.Concept;
import org.apache.uima.annotator.regex.Feature;
import org.apache.uima.annotator.regex.Rule;
import org.apache.uima.annotator.regex.impl.Annotation_impl;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.annotator.regex.impl.RuleComparator;
import org.apache.uima.annotator.regex.impl.Rule_impl;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Concept_impl
implements Concept {
    private ArrayList<Annotation> annotations;
    private Annotation[] annotArray;
    private String name;
    private ArrayList<Rule> rules;
    private boolean processAllRules;
    private Rule[] ruleList;

    public Concept_impl(String name, boolean processAllRules) {
        this.name = name;
        this.processAllRules = processAllRules;
        this.annotations = new ArrayList();
        this.rules = new ArrayList();
        this.ruleList = null;
        this.annotArray = null;
    }

    public void addAnnotation(Annotation aAnnotation) {
        this.annotations.add(aAnnotation);
        this.annotArray = this.annotations.toArray(new Annotation[0]);
    }

    public Annotation[] getAnnotations() {
        return this.annotArray;
    }

    public void addRule(Rule aRule) {
        this.rules.add(aRule);
        this.ruleList = this.rules.toArray(new Rule[0]);
        Arrays.sort(this.ruleList, new RuleComparator());
    }

    public String getName() {
        return this.name;
    }

    public Rule[] getRules() {
        return this.ruleList;
    }

    public boolean processAllConceptRules() {
        return this.processAllRules;
    }

    public void typeInit(TypeSystem ts) throws ResourceInitializationException {
        for (int i = 0; i < this.ruleList.length; ++i) {
            ((Rule_impl)this.ruleList[i]).typeInit(ts);
        }
        Annotation[] annots = this.getAnnotations();
        for (int i = 0; i < annots.length; ++i) {
            ((Annotation_impl)annots[i]).typeInit(ts);
        }
    }

    public void initialize(Logger logger) throws RegexAnnotatorConfigException {
        int i;
        Annotation[] annots = this.getAnnotations();
        for (i = 0; i < this.ruleList.length; ++i) {
            ((Rule_impl)this.ruleList[i]).initialize();
        }
        for (i = 0; i < annots.length; ++i) {
            ((Annotation_impl)annots[i]).initialize();
        }
        HashSet<String> ruleIds = new HashSet<String>(this.ruleList.length);
        for (int x = 0; x < this.ruleList.length; ++x) {
            String ruleID = this.ruleList[x].getId();
            if (ruleID == null) continue;
            if (ruleIds.contains(ruleID)) {
                logger.logrb(Level.WARNING, "RegExAnnotator", "initialize", "org.apache.uima.annotator.regex.regexMessages", "regex_annotator_warning_duplicate_rule_id", new Object[]{ruleID, this.name});
                continue;
            }
            ruleIds.add(ruleID);
        }
        HashSet<String> referenceIds = new HashSet<String>();
        HashSet<String> annotationIds = new HashSet<String>();
        for (int a = 0; a < annots.length; ++a) {
            String annotID = annots[a].getId();
            if (annotID != null) {
                if (annotationIds.contains(annotID)) {
                    throw new RegexAnnotatorConfigException("regex_annotator_error_duplicate_annotation_id", new Object[]{annotID, this.name});
                }
                annotationIds.add(annotID);
            }
            Feature[] features = annots[a].getFeatures();
            for (int f = 0; f < features.length; ++f) {
                if (features[f].getType() != 4) continue;
                referenceIds.add(features[f].getValue());
                if (annotID != null) continue;
                throw new RegexAnnotatorConfigException("regex_annotator_error_annotation_id_not_available", new Object[]{this.name});
            }
        }
        for (String refID : referenceIds) {
            if (annotationIds.contains(refID)) continue;
            throw new RegexAnnotatorConfigException("regex_annotator_error_referred_annotation_id_not_available", new Object[]{refID, this.name});
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Concept ");
        if (this.name != null) {
            buffer.append(this.name);
        }
        buffer.append("\nProcessAllConceptRules: " + this.processAllRules + "\n");
        if (this.ruleList.length > 0) {
            buffer.append("\nConcept rules: \n");
        }
        for (int i = 0; i < this.ruleList.length; ++i) {
            buffer.append(this.ruleList[i].toString());
        }
        Annotation[] annots = this.getAnnotations();
        if (annots.length > 0) {
            buffer.append("Annotations: \n");
        }
        for (int i = 0; i < annots.length; ++i) {
            buffer.append(annots[i].toString());
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

