/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.incubator.uima.regex.AnnotationDocument;
import org.apache.incubator.uima.regex.ConceptDocument;
import org.apache.incubator.uima.regex.ConceptSetDocument;
import org.apache.incubator.uima.regex.CreateAnnotationsDocument;
import org.apache.incubator.uima.regex.ExceptionDocument;
import org.apache.incubator.uima.regex.FeatureDocument;
import org.apache.incubator.uima.regex.RuleDocument;
import org.apache.incubator.uima.regex.RulesDocument;
import org.apache.incubator.uima.regex.SetFeatureDocument;
import org.apache.incubator.uima.regex.VariableDocument;
import org.apache.incubator.uima.regex.VariablesDocument;
import org.apache.uima.annotator.regex.Concept;
import org.apache.uima.annotator.regex.ConceptFileParser;
import org.apache.uima.annotator.regex.impl.Annotation_impl;
import org.apache.uima.annotator.regex.impl.Concept_impl;
import org.apache.uima.annotator.regex.impl.Feature_impl;
import org.apache.uima.annotator.regex.impl.FilterFeature_impl;
import org.apache.uima.annotator.regex.impl.Position_impl;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.annotator.regex.impl.RegexVariables_impl;
import org.apache.uima.annotator.regex.impl.RuleException_impl;
import org.apache.uima.annotator.regex.impl.Rule_impl;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.xmlbeans.XmlOptions;

public class ConceptFileParser_impl
implements ConceptFileParser {
    public Concept[] parseConceptFile(String conceptFilePathName, InputStream conceptFileStream) throws ResourceInitializationException {
        VariableDocument.Variable[] varArray;
        ConceptSetDocument conceptSetDoc;
        ArrayList<Concept_impl> conceptList = new ArrayList<Concept_impl>();
        try {
            conceptSetDoc = ConceptSetDocument.Factory.parse(conceptFileStream);
        }
        catch (Exception ex) {
            throw new RegexAnnotatorConfigException("regex_annotator_error_parsing_rule_set_file", new Object[]{conceptFilePathName}, ex);
        }
        ArrayList validationErrors = new ArrayList();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = conceptSetDoc.validate(validationOptions);
        if (!isValid) {
            Iterator iter = validationErrors.iterator();
            StringBuffer errorMessages = new StringBuffer();
            while (iter.hasNext()) {
                errorMessages.append("\n>> ");
                errorMessages.append(iter.next());
            }
            throw new RegexAnnotatorConfigException("regex_annotator_error_xml_validation", new Object[]{conceptFilePathName, errorMessages.toString()});
        }
        VariablesDocument.Variables variablesDoc = conceptSetDoc.getConceptSet().getVariables();
        RegexVariables_impl variables = null;
        if (variablesDoc != null && (varArray = variablesDoc.getVariableArray()).length > 0) {
            variables = new RegexVariables_impl();
            for (int i = 0; i < varArray.length; ++i) {
                String value = varArray[i].getValue().replaceAll("\\\\", "\\\\\\\\");
                variables.addVariable(varArray[i].getName(), value);
            }
        }
        ConceptSetDocument.ConceptSet conceptSet = conceptSetDoc.getConceptSet();
        ConceptDocument.Concept[] concepts = conceptSet.getConceptArray();
        for (int i = 0; i < concepts.length; ++i) {
            String conceptName = concepts[i].getName();
            boolean processAllRules = concepts[i].getProcessAllRules();
            Concept_impl concept = new Concept_impl(conceptName, processAllRules);
            RulesDocument.Rules rules = concepts[i].getRules();
            RuleDocument.Rule[] ruleList = rules.getRuleArray();
            for (int r = 0; r < ruleList.length; ++r) {
                String featureValue;
                String featureName;
                int x;
                String regex = ruleList[r].getRegEx();
                String matchType = ruleList[r].getMatchType();
                int matchStrategy = ruleList[r].getMatchStrategy().intValue();
                String id = ruleList[r].getRuleId();
                String featurePath = ruleList[r].getFeaturePath();
                float confidence = 0.0f;
                if (ruleList[r].getConfidence() != null) {
                    confidence = ruleList[r].getConfidence().floatValue();
                }
                Rule_impl rule = new Rule_impl(regex, matchStrategy, matchType, id, confidence, featurePath, variables);
                if (ruleList[r].getMatchTypeFilter() != null) {
                    FeatureDocument.Feature[] filterFeatures = ruleList[r].getMatchTypeFilter().getFeatureArray();
                    for (x = 0; x < filterFeatures.length; ++x) {
                        featureName = filterFeatures[x].getFeaturePath();
                        featureValue = filterFeatures[x].getStringValue();
                        FilterFeature_impl filterFeature = new FilterFeature_impl(featureName, featureValue);
                        rule.addFilterFeature(filterFeature);
                    }
                }
                if (ruleList[r].getUpdateMatchTypeAnnotation() != null) {
                    SetFeatureDocument.SetFeature[] updateFeatures = ruleList[r].getUpdateMatchTypeAnnotation().getSetFeatureArray();
                    for (x = 0; x < updateFeatures.length; ++x) {
                        featureName = updateFeatures[x].getName();
                        featureValue = updateFeatures[x].getStringValue();
                        int featureType = updateFeatures[x].getType().intValue();
                        int normalization = 0;
                        if (updateFeatures[x].getNormalization() != null) {
                            normalization = updateFeatures[x].getNormalization().intValue();
                        }
                        String implClass = updateFeatures[x].getClass1();
                        Feature_impl updateFeature = new Feature_impl(featureType, featureName, featureValue, normalization, implClass);
                        rule.addUpdateFeature(updateFeature);
                    }
                }
                if (ruleList[r].getRuleExceptions() != null) {
                    ExceptionDocument.Exception[] exceptions = ruleList[r].getRuleExceptions().getExceptionArray();
                    for (x = 0; x < exceptions.length; ++x) {
                        String exceptionMatchType = exceptions[x].getMatchType();
                        String regexPattern = exceptions[x].getStringValue();
                        RuleException_impl exception = new RuleException_impl(exceptionMatchType, regexPattern);
                        rule.addException(exception);
                    }
                }
                concept.addRule(rule);
            }
            CreateAnnotationsDocument.CreateAnnotations annotations = concepts[i].getCreateAnnotations();
            AnnotationDocument.Annotation[] annotationList = annotations.getAnnotationArray();
            for (int a = 0; a < annotationList.length; ++a) {
                int beginMatchGroup = annotationList[a].getBegin().getGroup().intValue();
                int beginLocation = annotationList[a].getBegin().getLocation().intValue();
                int endMatchGroup = annotationList[a].getEnd().getGroup().intValue();
                int endLocation = annotationList[a].getEnd().getLocation().intValue();
                Position_impl begin = new Position_impl(beginMatchGroup, beginLocation);
                Position_impl end = new Position_impl(endMatchGroup, endLocation);
                String id = annotationList[a].getId();
                String type = annotationList[a].getType();
                String validationClass = annotationList[a].getValidate();
                Annotation_impl annotation = new Annotation_impl(id, type, begin, end, validationClass);
                SetFeatureDocument.SetFeature[] features = annotationList[a].getSetFeatureArray();
                for (int f = 0; f < features.length; ++f) {
                    String name = features[f].getName();
                    int featureType = features[f].getType().intValue();
                    String value = features[f].getStringValue();
                    int normalization = 0;
                    if (features[f].getNormalization() != null) {
                        normalization = features[f].getNormalization().intValue();
                    }
                    String implClass = features[f].getClass1();
                    Feature_impl feature = new Feature_impl(featureType, name, value, normalization, implClass);
                    annotation.addFeature(feature);
                }
                concept.addAnnotation(annotation);
            }
            conceptList.add(concept);
        }
        return conceptList.toArray(new Concept[0]);
    }
}

