/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.mapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.uima.lucas.indexer.mapping.AnnotationDescription;
import org.apache.uima.lucas.indexer.mapping.ElementMapper;
import org.apache.uima.lucas.indexer.mapping.FeatureDescription;
import org.apache.uima.lucas.indexer.mapping.FieldDescription;
import org.apache.uima.lucas.indexer.mapping.FilterDescription;
import org.apache.uima.lucas.indexer.mapping.Locateable;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileReader
extends DefaultHandler {
    public static final String FIELD = "field";
    public static final String FILTER = "filter";
    public static final String ANNOTATION = "annotation";
    public static final String FEATURE = "feature";
    private Collection<FieldDescription> fieldDescriptions = new ArrayList<FieldDescription>();
    private SAXParser parser;
    private FieldDescription currentFieldDescription;
    private AnnotationDescription currentAnnotationDescription;
    private Locator currentLocator;
    private Map<String, ElementMapper<?>> elementMappers;

    public MappingFileReader(SAXParser parser, Map<String, ElementMapper<?>> elementMappers) throws IOException {
        this.parser = parser;
        this.elementMappers = elementMappers;
    }

    public Collection<FieldDescription> readFieldDescriptionsFromFile(File mappingFile) throws IOException, SAXException {
        this.parseFile(mappingFile);
        return this.fieldDescriptions;
    }

    private void parseFile(File mappingFile) throws IOException, SAXException {
        this.parser.parse(mappingFile, (DefaultHandler)this);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.currentLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(FIELD)) {
            this.addFieldDescription(attributes);
        } else if (qName.equals(FILTER)) {
            this.addFilterDescription(attributes);
        } else if (qName.equals(ANNOTATION)) {
            this.addAnnotationDescription(attributes);
        } else if (qName.equals(FEATURE)) {
            this.addFeatureDescription(attributes);
        }
    }

    private void addFieldDescription(Attributes attributes) {
        ElementMapper<?> elementMapper = this.elementMappers.get(FIELD);
        this.currentFieldDescription = (FieldDescription)elementMapper.mapElement(attributes);
        this.currentAnnotationDescription = null;
        this.mapLocator(this.currentFieldDescription);
        this.fieldDescriptions.add(this.currentFieldDescription);
    }

    private void addFilterDescription(Attributes attributes) {
        ElementMapper<?> filterMapper = this.elementMappers.get(FILTER);
        FilterDescription filterDescription = (FilterDescription)filterMapper.mapElement(attributes);
        this.mapLocator(filterDescription);
        if (this.currentAnnotationDescription != null) {
            Collection<FilterDescription> filterDescriptions = this.currentAnnotationDescription.getFilterDescriptions();
            filterDescriptions.add(filterDescription);
        } else {
            Collection<FilterDescription> filterDescriptions = this.currentFieldDescription.getFilterDescriptions();
            filterDescriptions.add(filterDescription);
        }
    }

    private void addAnnotationDescription(Attributes attributes) {
        ElementMapper<?> annotationMapper = this.elementMappers.get(ANNOTATION);
        this.currentAnnotationDescription = (AnnotationDescription)annotationMapper.mapElement(attributes);
        this.mapLocator(this.currentAnnotationDescription);
        Collection<AnnotationDescription> annotationDescriptions = this.currentFieldDescription.getAnnotationDescriptions();
        annotationDescriptions.add(this.currentAnnotationDescription);
    }

    private void addFeatureDescription(Attributes attributes) {
        ElementMapper<?> featureMapper = this.elementMappers.get(FEATURE);
        FeatureDescription featureDescription = (FeatureDescription)featureMapper.mapElement(attributes);
        this.mapLocator(featureDescription);
        Collection<FeatureDescription> featureDescriptions = this.currentAnnotationDescription.getFeatureDescriptions();
        featureDescriptions.add(featureDescription);
    }

    private void mapLocator(Locateable locateable) {
        if (this.currentLocator != null) {
            int lineNumber = this.currentLocator.getLineNumber();
            locateable.setLineNumber(lineNumber);
            int columnNumber = this.currentLocator.getColumnNumber();
            locateable.setColumnNumber(columnNumber);
        }
    }
}

