/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class UniqueFilter
extends TokenFilter {
    private TokenStream input;
    private Collection<String> termTexts;
    private Token currentToken;

    public UniqueFilter(TokenStream input) {
        super(input);
        this.input = input;
        this.termTexts = new HashSet<String>();
    }

    public Token next(Token inputToken) throws IOException {
        this.currentToken = this.input.next(inputToken);
        if (this.currentToken == null) {
            return null;
        }
        String termText = new String(this.currentToken.termBuffer(), 0, this.currentToken.termLength());
        while (this.termTexts.contains(termText)) {
            this.currentToken = this.input.next(inputToken);
            if (this.currentToken != null) {
                termText = new String(this.currentToken.termBuffer(), 0, this.currentToken.termLength());
                continue;
            }
            termText = null;
        }
        if (this.currentToken == null) {
            return null;
        }
        this.termTexts.add(termText);
        return this.currentToken;
    }

    public void reset() throws IOException {
        this.input.reset();
        this.termTexts.clear();
    }
}

