/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;

public class SnowballFilterFactory
implements TokenFilterFactory {
    public static final String STEMMER_NAME_PARAMETER = "stemmerName";
    private static final String DEFAULT_STEMMER_NAME = "English";

    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String stemmerName = properties.getProperty(STEMMER_NAME_PARAMETER);
        if (stemmerName == null) {
            stemmerName = DEFAULT_STEMMER_NAME;
        }
        return new SnowballFilter(tokenStream, stemmerName);
    }

    public void preloadResources(Properties properties) throws IOException {
    }
}

