/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.analysis.PositionFilter;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;

public class PositionFilterFactory
implements TokenFilterFactory {
    public static final String POSITION_PARAMETER = "position";
    public static final String FIRST_POSITION_PARAMETER_VALUE = "first";
    public static final String LAST_POSITION_PARAMETER_VALUE = "last";

    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String positionAttribute = properties.getProperty(POSITION_PARAMETER);
        Integer position = -1;
        if (positionAttribute == null) {
            throw new IllegalArgumentException("no position information provided");
        }
        if (positionAttribute.equals(FIRST_POSITION_PARAMETER_VALUE)) {
            position = PositionFilter.FIRST_POSITION;
        } else if (positionAttribute.equals(LAST_POSITION_PARAMETER_VALUE)) {
            position = PositionFilter.LAST_POSITION;
        } else {
            throw new IllegalArgumentException("unknown position value: " + positionAttribute);
        }
        return new PositionFilter(tokenStream, position);
    }

    public void preloadResources(Properties properties) throws IOException {
    }
}

