/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypernymFilter
extends TokenFilter {
    private static Logger logger = Logger.getLogger(HypernymFilter.class);
    private Map<String, List<String>> hypernyms;
    private TokenStream tokenStream;
    private int currentHypernymIndex;
    private List<String> currentHypernyms;
    private Token inputToken;

    public HypernymFilter(TokenStream input, Map<String, List<String>> hypernyms) {
        super(input);
        this.hypernyms = hypernyms;
        this.tokenStream = input;
        this.currentHypernymIndex = -1;
    }

    public Token next(Token nextToken) throws IOException {
        if (this.currentHypernymIndex >= 0 && this.currentHypernymIndex < this.currentHypernyms.size()) {
            nextToken.reinit(this.currentHypernyms.get(this.currentHypernymIndex), this.inputToken.startOffset(), this.inputToken.endOffset());
            nextToken.setPositionIncrement(0);
            logger.debug((Object)("adding hypernym " + nextToken.term() + " for :" + this.inputToken.term()));
            ++this.currentHypernymIndex;
            return nextToken;
        }
        if (this.currentHypernymIndex >= 0 && this.currentHypernymIndex == this.currentHypernyms.size()) {
            this.currentHypernymIndex = -1;
            this.currentHypernyms = null;
        }
        this.inputToken = this.tokenStream.next(nextToken);
        if (this.inputToken != null) {
            this.currentHypernyms = this.hypernyms.get(this.inputToken.term());
            if (this.currentHypernyms != null) {
                this.currentHypernymIndex = 0;
            }
        }
        return this.inputToken;
    }

    public void reset() throws IOException {
        this.inputToken = null;
        this.currentHypernymIndex = -1;
        if (this.currentHypernyms != null) {
            this.currentHypernyms = null;
        }
        this.tokenStream.reset();
    }

    public Map<String, List<String>> getHypernyms() {
        return this.hypernyms;
    }
}

