/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.lucas.indexer.analysis.AdditionFilterFactory;
import org.apache.uima.lucas.indexer.analysis.ConcatFilterFactory;
import org.apache.uima.lucas.indexer.analysis.HypernymFilterFactory;
import org.apache.uima.lucas.indexer.analysis.LowerCaseFilterFactory;
import org.apache.uima.lucas.indexer.analysis.PositionFilterFactory;
import org.apache.uima.lucas.indexer.analysis.ReplaceFilterFactory;
import org.apache.uima.lucas.indexer.analysis.SnowballFilterFactory;
import org.apache.uima.lucas.indexer.analysis.SplitterFilterFactory;
import org.apache.uima.lucas.indexer.analysis.StopwordFilterFactory;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.analysis.UniqueFilterFactory;
import org.apache.uima.lucas.indexer.analysis.UpperCaseFilterFactory;
import org.apache.uima.lucas.indexer.util.MapFileReaderFactory;
import org.apache.uima.lucas.indexer.util.MultimapFileReaderFactory;
import org.apache.uima.lucas.indexer.util.PlainFileReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilterFactoryRegistry {
    public static final String ADDITION_FILTER_FACTORY_NAME = "addition";
    public static final String HYPERNYM_FILTER_FACTORY_NAME = "hypernyms";
    public static final String POSITION_FILTER_FACTORY_NAME = "position";
    public static final String REPLACE_FILTER_FACTORY_NAME = "replace";
    public static final String SNOWBALL_FILTER_FACTORY_NAME = "snowball";
    public static final String SPLITTER_FILTER_FACTORY_NAME = "splitter";
    public static final String STOPWORD_FILTER_FACTORY_NAME = "stopwords";
    public static final String UNIQUE_FILTER_FACTORY_NAME = "unique";
    public static final String UPPERCASE_FILTER_FACTORY_NAME = "uppercase";
    public static final String LOWERCASE_FILTER_FACTORY_NAME = "lowercase";
    public static final String UEA_FILTER_FACTORY_NAME = "uea-stemmer";
    public static final String CONCAT_FILTER_FACTORY_NAME = "concatenate";

    public Map<String, TokenFilterFactory> getDefaultRegistry() {
        HashMap<String, TokenFilterFactory> registry = new HashMap<String, TokenFilterFactory>();
        registry.put(ADDITION_FILTER_FACTORY_NAME, new AdditionFilterFactory());
        registry.put(HYPERNYM_FILTER_FACTORY_NAME, new HypernymFilterFactory(new MultimapFileReaderFactory()));
        registry.put(POSITION_FILTER_FACTORY_NAME, new PositionFilterFactory());
        registry.put(REPLACE_FILTER_FACTORY_NAME, new ReplaceFilterFactory(new MapFileReaderFactory()));
        registry.put(SNOWBALL_FILTER_FACTORY_NAME, new SnowballFilterFactory());
        registry.put(SPLITTER_FILTER_FACTORY_NAME, new SplitterFilterFactory());
        registry.put(CONCAT_FILTER_FACTORY_NAME, new ConcatFilterFactory());
        registry.put(STOPWORD_FILTER_FACTORY_NAME, new StopwordFilterFactory(new PlainFileReaderFactory()));
        registry.put(UNIQUE_FILTER_FACTORY_NAME, new UniqueFilterFactory());
        registry.put(UPPERCASE_FILTER_FACTORY_NAME, new UpperCaseFilterFactory());
        registry.put(LOWERCASE_FILTER_FACTORY_NAME, new LowerCaseFilterFactory());
        return registry;
    }
}

