/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.analysis.AdditionFilter;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;

public class AdditionFilterFactory
implements TokenFilterFactory {
    public static final String POSTFIX_POSITION = "postfix";
    public static final String PREFIX_POSITION = "prefix";

    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String postfix = properties.getProperty(POSTFIX_POSITION);
        String addition = null;
        Integer position = null;
        if (postfix != null) {
            position = AdditionFilter.POSTFIX;
            addition = postfix;
        } else {
            String prefix = properties.getProperty(PREFIX_POSITION);
            if (prefix != null) {
                position = AdditionFilter.PREFIX;
                addition = prefix;
            } else {
                throw new IllegalArgumentException("no postfix or prefix attribute provided");
            }
        }
        return new AdditionFilter(tokenStream, addition, position);
    }

    public void preloadResources(Properties properties) throws IOException {
    }
}

