/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.uima.lucas.indexer.mapping.AnnotationDescription;
import org.apache.uima.lucas.indexer.util.TokenStreamStringConcatenator;

public class Tokenizer {
    public static final String TOKENIZER_WHITESPACE = "whitespace";
    public static final String TOKENIZER_CAS = "cas";
    public static final String TOKENIZER_STANDARD = "standard";
    private TokenStreamStringConcatenator tokenStreamStringConcatenator = new TokenStreamStringConcatenator();

    public boolean needsTokenization(AnnotationDescription annotationDescription) {
        String tokenizer = annotationDescription.getTokenizer();
        return tokenizer != null && !tokenizer.equals(TOKENIZER_CAS);
    }

    public TokenStream tokenize(TokenStream tokenStream, AnnotationDescription description) throws IOException {
        String tokenizer = description.getTokenizer();
        if (tokenizer != null && !tokenizer.equals(TOKENIZER_CAS)) {
            String tokenStreamAsString = this.tokenStreamStringConcatenator.tokenStreamToStringWithDelimiter(tokenStream, " ");
            StringReader stringReader = new StringReader(tokenStreamAsString);
            if (tokenizer.equals(TOKENIZER_WHITESPACE)) {
                tokenStream = new WhitespaceTokenizer((Reader)stringReader);
            } else if (tokenizer.equals(TOKENIZER_STANDARD)) {
                tokenStream = new StandardTokenizer((Reader)stringReader);
            }
        }
        return tokenStream;
    }
}

