/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.uima.lucas.indexer.IndexWriterProvider;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;

public class IndexWriterProviderImpl
implements IndexWriterProvider,
SharedResourceObject {
    public static final String USE_COMPOUND_FILE_FORMAT_PROPERTY = "useCompoundFileFormat";
    public static final String RAMBUFFER_SIZE_PROPERTY = "RAMBufferSize";
    public static final String INDEX_PATH_PROPERTY = "indexPath";
    public static final String CREATE_INDEX_PROPERTY = "createIndex";
    public static final String MAX_FIELD_LENGTH_PROPERTY = "maxFieldLength";
    public static final String UNIQUE_INDEX_PROPERTY = "uniqueIndex";
    private static Set<Integer> randomNumbers = new HashSet<Integer>();
    public IndexWriter indexWriter;

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public void load(DataResource dataResource) throws ResourceInitializationException {
        Properties properties = this.loadProperties(dataResource);
        String indexPath = this.getIndexPath(properties);
        if (this.getUniqueIndexOrDefault(properties).booleanValue()) {
            indexPath = this.createUniqueIndexPath(indexPath);
        }
        IndexWriter.MaxFieldLength maxFieldLength = this.getMaxFieldLengthOrDefault(properties);
        boolean createIndex = this.getCreateIndexOrDefault(properties);
        this.createIndexWriter(indexPath, maxFieldLength, createIndex);
        Double ramBufferSize = this.getRAMBufferSizeOrDefault(properties);
        Boolean useCompoundFileFormat = this.getUseCompoundFormatOrDefault(properties);
        this.configureIndexWriter(ramBufferSize, useCompoundFileFormat);
    }

    private Properties loadProperties(DataResource dataResource) throws ResourceInitializationException {
        Properties properties = new Properties();
        try {
            properties.load(dataResource.getInputStream());
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        return properties;
    }

    private Boolean getUseCompoundFormatOrDefault(Properties properties) {
        String useCompoundFileFormatAsString = properties.getProperty(USE_COMPOUND_FILE_FORMAT_PROPERTY);
        Boolean useCompoundFileFormat = true;
        if (useCompoundFileFormatAsString != null) {
            useCompoundFileFormat = new Boolean(useCompoundFileFormatAsString);
        }
        return useCompoundFileFormat;
    }

    private String getIndexPath(Properties properties) {
        return properties.getProperty(INDEX_PATH_PROPERTY);
    }

    private synchronized int createRandom() {
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(1000000);
        while (randomNumbers.contains(randomInt)) {
            randomInt = randomGenerator.nextInt(1000000);
        }
        randomNumbers.add(randomInt);
        return randomInt;
    }

    private String createUniqueIndexPath(String indexPath) {
        String uniqueIndexPath = indexPath + "-" + this.getHostName() + "-" + this.getPID() + "-" + this.createRandom();
        return uniqueIndexPath;
    }

    private Boolean getUniqueIndexOrDefault(Properties properties) {
        String uniqueIndexAsString = properties.getProperty(UNIQUE_INDEX_PROPERTY);
        Boolean uniqueIndex = false;
        if (uniqueIndexAsString != null) {
            uniqueIndex = new Boolean(uniqueIndexAsString);
        }
        return uniqueIndex;
    }

    private Double getRAMBufferSizeOrDefault(Properties properties) {
        String ramBufferSizeAsString = properties.getProperty(RAMBUFFER_SIZE_PROPERTY);
        Double ramBufferSize = 16.0;
        if (ramBufferSizeAsString != null) {
            ramBufferSize = new Double(ramBufferSizeAsString);
        }
        return ramBufferSize;
    }

    private IndexWriter.MaxFieldLength getMaxFieldLengthOrDefault(Properties properties) {
        String maxFieldLengthAsString = properties.getProperty(MAX_FIELD_LENGTH_PROPERTY);
        if (maxFieldLengthAsString == null) {
            return IndexWriter.MaxFieldLength.UNLIMITED;
        }
        Integer maxFieldLength = new Integer(maxFieldLengthAsString);
        return new IndexWriter.MaxFieldLength(maxFieldLength.intValue());
    }

    private boolean getCreateIndexOrDefault(Properties properties) {
        String createIndexAsString = properties.getProperty(CREATE_INDEX_PROPERTY);
        if (createIndexAsString != null) {
            return Boolean.parseBoolean(createIndexAsString);
        }
        return true;
    }

    private void createIndexWriter(String indexPath, IndexWriter.MaxFieldLength maxFieldLength, boolean create) throws ResourceInitializationException {
        try {
            this.indexWriter = new IndexWriter(indexPath, (Analyzer)new StandardAnalyzer(), create, maxFieldLength);
        }
        catch (CorruptIndexException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (LockObtainFailedException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void configureIndexWriter(Double ramBufferSize, Boolean useCompoundFileFormat) {
        this.indexWriter.setRAMBufferSizeMB(ramBufferSize.doubleValue());
        this.indexWriter.setUseCompoundFile(true);
    }

    private String getPID() {
        String id = ManagementFactory.getRuntimeMXBean().getName();
        return id.substring(0, id.indexOf("@"));
    }

    private String getHostName() {
        String hostName;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostName = address.getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        return hostName;
    }
}

