/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.ExtendedFieldCache;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.SortComparator;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.lucene.util.StringHelper;

class FieldCacheImpl
implements ExtendedFieldCache {
    private Map caches;
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(7);
        this.caches.put(Byte.TYPE, new ByteCache(this));
        this.caches.put(Short.TYPE, new ShortCache(this));
        this.caches.put(Integer.TYPE, new IntCache(this));
        this.caches.put(Float.TYPE, new FloatCache(this));
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(Double.TYPE, new DoubleCache(this));
        this.caches.put(String.class, new StringCache(this));
        this.caches.put(FieldCache.StringIndex.class, new StringIndexCache(this));
        this.caches.put(Comparable.class, new CustomCache(this));
        this.caches.put(Object.class, new AutoCache(this));
    }

    public void purgeAllCaches() {
        this.init();
    }

    public void purge(IndexReader r) {
        Iterator it = this.caches.values().iterator();
        while (it.hasNext()) {
            Cache c = (Cache)it.next();
            c.purge(r);
        }
    }

    public FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<CacheEntryImpl> result = new ArrayList<CacheEntryImpl>(17);
        Iterator outerKeys = this.caches.keySet().iterator();
        while (outerKeys.hasNext()) {
            Class cacheType = (Class)outerKeys.next();
            Cache cache = (Cache)this.caches.get(cacheType);
            Iterator innerKeys = cache.readerCache.keySet().iterator();
            while (innerKeys.hasNext()) {
                Object readerKey = innerKeys.next();
                if (null == readerKey || !cache.readerCache.containsKey(readerKey)) continue;
                Map innerCache = (Map)cache.readerCache.get(readerKey);
                Iterator entrySetIterator = innerCache.entrySet().iterator();
                while (entrySetIterator.hasNext()) {
                    Map.Entry mapEntry = entrySetIterator.next();
                    Entry entry = (Entry)mapEntry.getKey();
                    result.add(new CacheEntryImpl(readerKey, entry.field, cacheType, entry.type, entry.custom, entry.locale, mapEntry.getValue()));
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    public byte[] getBytes(IndexReader reader, String field) throws IOException {
        return this.getBytes(reader, field, null);
    }

    public byte[] getBytes(IndexReader reader, String field, FieldCache.ByteParser parser) throws IOException {
        return (byte[])((Cache)this.caches.get(Byte.TYPE)).get(reader, new Entry(field, parser));
    }

    public short[] getShorts(IndexReader reader, String field) throws IOException {
        return this.getShorts(reader, field, null);
    }

    public short[] getShorts(IndexReader reader, String field, FieldCache.ShortParser parser) throws IOException {
        return (short[])((Cache)this.caches.get(Short.TYPE)).get(reader, new Entry(field, parser));
    }

    public int[] getInts(IndexReader reader, String field) throws IOException {
        return this.getInts(reader, field, null);
    }

    public int[] getInts(IndexReader reader, String field, FieldCache.IntParser parser) throws IOException {
        return (int[])((Cache)this.caches.get(Integer.TYPE)).get(reader, new Entry(field, parser));
    }

    public float[] getFloats(IndexReader reader, String field) throws IOException {
        return this.getFloats(reader, field, null);
    }

    public float[] getFloats(IndexReader reader, String field, FieldCache.FloatParser parser) throws IOException {
        return (float[])((Cache)this.caches.get(Float.TYPE)).get(reader, new Entry(field, parser));
    }

    public long[] getLongs(IndexReader reader, String field) throws IOException {
        return this.getLongs(reader, field, null);
    }

    public long[] getLongs(IndexReader reader, String field, FieldCache.LongParser parser) throws IOException {
        return (long[])((Cache)this.caches.get(Long.TYPE)).get(reader, new Entry(field, parser));
    }

    public long[] getLongs(IndexReader reader, String field, ExtendedFieldCache.LongParser parser) throws IOException {
        return (long[])((Cache)this.caches.get(Long.TYPE)).get(reader, new Entry(field, parser));
    }

    public double[] getDoubles(IndexReader reader, String field) throws IOException {
        return this.getDoubles(reader, field, null);
    }

    public double[] getDoubles(IndexReader reader, String field, FieldCache.DoubleParser parser) throws IOException {
        return (double[])((Cache)this.caches.get(Double.TYPE)).get(reader, new Entry(field, parser));
    }

    public double[] getDoubles(IndexReader reader, String field, ExtendedFieldCache.DoubleParser parser) throws IOException {
        return (double[])((Cache)this.caches.get(Double.TYPE)).get(reader, new Entry(field, parser));
    }

    public String[] getStrings(IndexReader reader, String field) throws IOException {
        return (String[])((Cache)this.caches.get(String.class)).get(reader, new Entry(field, null));
    }

    public FieldCache.StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        return (FieldCache.StringIndex)((Cache)this.caches.get(FieldCache.StringIndex.class)).get(reader, new Entry(field, null));
    }

    public Object getAuto(IndexReader reader, String field) throws IOException {
        return ((Cache)this.caches.get(Object.class)).get(reader, new Entry(field, null));
    }

    public Comparable[] getCustom(IndexReader reader, String field, SortComparator comparator) throws IOException {
        return (Comparable[])((Cache)this.caches.get(Comparable.class)).get(reader, new Entry(field, comparator));
    }

    public void setInfoStream(PrintStream stream) {
        this.infoStream = stream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class CustomCache
    extends Cache {
        CustomCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            SortComparator comparator = (SortComparator)entry.custom;
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null && term.field() == field) {
                    Comparable termval = comparator.getComparable(term.text());
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                termDocs.close();
                termEnum.close();
                throw throwable;
            }
            termDocs.close();
            termEnum.close();
            return retArray;
        }
    }

    static final class AutoCache
    extends Cache {
        AutoCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            int[] nArray;
            String field = StringHelper.intern(entryKey.field);
            TermEnum enumerator = reader.terms(new Term(field));
            try {
                Term term = enumerator.term();
                if (term == null) {
                    throw new RuntimeException("no terms in field " + field + " - cannot determine type");
                }
                Object ret = null;
                if (term.field() == field) {
                    String termtext = term.text().trim();
                    try {
                        Integer.parseInt(termtext);
                        ret = this.wrapper.getInts(reader, field);
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            Long.parseLong(termtext);
                            ret = this.wrapper.getLongs(reader, field);
                        }
                        catch (NumberFormatException nfe2) {
                            try {
                                Float.parseFloat(termtext);
                                ret = this.wrapper.getFloats(reader, field);
                            }
                            catch (NumberFormatException nfe3) {
                                ret = this.wrapper.getStringIndex(reader, field);
                            }
                        }
                    }
                } else {
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                nArray = ret;
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                enumerator.close();
                throw throwable;
            }
            enumerator.close();
            return nArray;
        }
    }

    static final class StringIndexCache
    extends Cache {
        StringIndexCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            String field = StringHelper.intern(entryKey.field);
            int[] retArray = new int[reader.maxDoc()];
            String[] mterms = new String[reader.maxDoc() + 1];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            int t = 0;
            mterms[t++] = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null && term.field() == field) {
                    mterms[t] = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = t;
                    }
                    ++t;
                    if (termEnum.next()) continue;
                    break;
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                termDocs.close();
                termEnum.close();
                throw throwable;
            }
            termDocs.close();
            termEnum.close();
            if (t == 0) {
                mterms = new String[1];
            } else if (t < mterms.length) {
                String[] terms = new String[t];
                System.arraycopy(mterms, 0, terms, 0, t);
                mterms = terms;
            }
            FieldCache.StringIndex value = new FieldCache.StringIndex(retArray, mterms);
            return value;
        }
    }

    static final class StringCache
    extends Cache {
        StringCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            String field = StringHelper.intern(entryKey.field);
            String[] retArray = new String[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null && term.field() == field) {
                    String termval = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                termDocs.close();
                termEnum.close();
                throw throwable;
            }
            termDocs.close();
            termEnum.close();
            return retArray;
        }
    }

    static final class DoubleCache
    extends Cache {
        DoubleCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            double[] retArray;
            block11: {
                Term term;
                Entry entry = entryKey;
                String field = entry.field;
                FieldCache.DoubleParser parser = (FieldCache.DoubleParser)entry.custom;
                if (parser == null) {
                    try {
                        return this.wrapper.getDoubles(reader, field, FieldCache.DEFAULT_DOUBLE_PARSER);
                    }
                    catch (NumberFormatException ne) {
                        return this.wrapper.getDoubles(reader, field, FieldCache.NUMERIC_UTILS_DOUBLE_PARSER);
                    }
                }
                retArray = null;
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field));
                try {
                    try {}
                    catch (StopFillCacheException stop) {
                        Object var13_14 = null;
                        termDocs.close();
                        termEnum.close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                while ((term = termEnum.term()) != null && term.field() == field) {
                    double termval = parser.parseDouble(term.text());
                    if (retArray == null) {
                        retArray = new double[reader.maxDoc()];
                    }
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var13_13 = null;
                termDocs.close();
                termEnum.close();
            }
            if (retArray != null) return retArray;
            return new double[reader.maxDoc()];
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            long[] retArray;
            block11: {
                Term term;
                Entry entry = entryKey;
                String field = entry.field;
                FieldCache.LongParser parser = (FieldCache.LongParser)entry.custom;
                if (parser == null) {
                    try {
                        return this.wrapper.getLongs(reader, field, FieldCache.DEFAULT_LONG_PARSER);
                    }
                    catch (NumberFormatException ne) {
                        return this.wrapper.getLongs(reader, field, FieldCache.NUMERIC_UTILS_LONG_PARSER);
                    }
                }
                retArray = null;
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field));
                try {
                    try {}
                    catch (StopFillCacheException stop) {
                        Object var13_14 = null;
                        termDocs.close();
                        termEnum.close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                while ((term = termEnum.term()) != null && term.field() == field) {
                    long termval = parser.parseLong(term.text());
                    if (retArray == null) {
                        retArray = new long[reader.maxDoc()];
                    }
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var13_13 = null;
                termDocs.close();
                termEnum.close();
            }
            if (retArray != null) return retArray;
            return new long[reader.maxDoc()];
        }
    }

    static final class FloatCache
    extends Cache {
        FloatCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            float[] retArray;
            block11: {
                Term term;
                Entry entry = entryKey;
                String field = entry.field;
                FieldCache.FloatParser parser = (FieldCache.FloatParser)entry.custom;
                if (parser == null) {
                    try {
                        return this.wrapper.getFloats(reader, field, FieldCache.DEFAULT_FLOAT_PARSER);
                    }
                    catch (NumberFormatException ne) {
                        return this.wrapper.getFloats(reader, field, FieldCache.NUMERIC_UTILS_FLOAT_PARSER);
                    }
                }
                retArray = null;
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field));
                try {
                    try {}
                    catch (StopFillCacheException stop) {
                        Object var12_14 = null;
                        termDocs.close();
                        termEnum.close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                while ((term = termEnum.term()) != null && term.field() == field) {
                    float termval = parser.parseFloat(term.text());
                    if (retArray == null) {
                        retArray = new float[reader.maxDoc()];
                    }
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var12_13 = null;
                termDocs.close();
                termEnum.close();
            }
            if (retArray != null) return retArray;
            return new float[reader.maxDoc()];
        }
    }

    static final class IntCache
    extends Cache {
        IntCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            int[] retArray;
            block11: {
                Term term;
                Entry entry = entryKey;
                String field = entry.field;
                FieldCache.IntParser parser = (FieldCache.IntParser)entry.custom;
                if (parser == null) {
                    try {
                        return this.wrapper.getInts(reader, field, FieldCache.DEFAULT_INT_PARSER);
                    }
                    catch (NumberFormatException ne) {
                        return this.wrapper.getInts(reader, field, FieldCache.NUMERIC_UTILS_INT_PARSER);
                    }
                }
                retArray = null;
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field));
                try {
                    try {}
                    catch (StopFillCacheException stop) {
                        Object var12_14 = null;
                        termDocs.close();
                        termEnum.close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                while ((term = termEnum.term()) != null && term.field() == field) {
                    int termval = parser.parseInt(term.text());
                    if (retArray == null) {
                        retArray = new int[reader.maxDoc()];
                    }
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        retArray[termDocs.doc()] = termval;
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var12_13 = null;
                termDocs.close();
                termEnum.close();
            }
            if (retArray != null) return retArray;
            return new int[reader.maxDoc()];
        }
    }

    static final class ShortCache
    extends Cache {
        ShortCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Term term;
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.ShortParser parser = (FieldCache.ShortParser)entry.custom;
            if (parser == null) {
                return this.wrapper.getShorts(reader, field, FieldCache.DEFAULT_SHORT_PARSER);
            }
            short[] retArray = new short[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                try {}
                catch (StopFillCacheException stop) {
                    Object var12_13 = null;
                    termDocs.close();
                    termEnum.close();
                    return retArray;
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                termDocs.close();
                termEnum.close();
                throw throwable;
            }
            while ((term = termEnum.term()) != null && term.field() == field) {
                short termval = parser.parseShort(term.text());
                termDocs.seek(termEnum);
                while (termDocs.next()) {
                    retArray[termDocs.doc()] = termval;
                }
                if (termEnum.next()) continue;
                break;
            }
            Object var12_12 = null;
            termDocs.close();
            termEnum.close();
            return retArray;
        }
    }

    static final class ByteCache
    extends Cache {
        ByteCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Term term;
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.ByteParser parser = (FieldCache.ByteParser)entry.custom;
            if (parser == null) {
                return this.wrapper.getBytes(reader, field, FieldCache.DEFAULT_BYTE_PARSER);
            }
            byte[] retArray = new byte[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                try {}
                catch (StopFillCacheException stop) {
                    Object var12_13 = null;
                    termDocs.close();
                    termEnum.close();
                    return retArray;
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                termDocs.close();
                termEnum.close();
                throw throwable;
            }
            while ((term = termEnum.term()) != null && term.field() == field) {
                byte termval = parser.parseByte(term.text());
                termDocs.seek(termEnum);
                while (termDocs.next()) {
                    retArray[termDocs.doc()] = termval;
                }
                if (termEnum.next()) continue;
                break;
            }
            Object var12_12 = null;
            termDocs.close();
            termEnum.close();
            return retArray;
        }
    }

    static class Entry {
        final String field;
        final int type;
        final Object custom;
        final Locale locale;

        Entry(String field, int type, Locale locale) {
            this.field = StringHelper.intern(field);
            this.type = type;
            this.custom = null;
            this.locale = locale;
        }

        Entry(String field, Object custom) {
            this.field = StringHelper.intern(field);
            this.type = 9;
            this.custom = custom;
            this.locale = null;
        }

        Entry(String field, int type, FieldCache.Parser parser) {
            this.field = StringHelper.intern(field);
            this.type = type;
            this.custom = parser;
            this.locale = null;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field == this.field && other.type == this.type && (other.locale == null ? this.locale == null : other.locale.equals(this.locale)) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.type ^ (this.custom == null ? 0 : this.custom.hashCode()) ^ (this.locale == null ? 0 : this.locale.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCache wrapper;
        final Map readerCache = new WeakHashMap();

        Cache() {
            this.wrapper = null;
        }

        Cache(FieldCache wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Object createValue(IndexReader var1, Entry var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purge(IndexReader r) {
            Object readerKey = r.getFieldCacheKey();
            Map map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(readerKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Entry key) throws IOException {
            Object value;
            HashMap<Entry, Object> innerCache;
            Object readerKey = reader.getFieldCacheKey();
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = (HashMap<Entry, Object>)this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<Entry, Object>();
                    this.readerCache.put(readerKey, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        PrintStream infoStream;
                        progress.value = this.createValue(reader, key);
                        Map map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                        if (key.custom != null && this.wrapper != null && (infoStream = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity(infoStream, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        private void printNewInsanity(PrintStream infoStream, Object value) {
            FieldCacheSanityChecker.Insanity[] insanities = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanities.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanities[i];
                FieldCache.CacheEntry[] entries = insanity.getCacheEntries();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getValue() != value) continue;
                    infoStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    infoStream.println("\nStack:\n");
                    new Throwable().printStackTrace(infoStream);
                    continue block0;
                }
            }
        }
    }

    static final class StopFillCacheException
    extends RuntimeException {
        StopFillCacheException() {
        }
    }

    private static final class CacheEntryImpl
    extends FieldCache.CacheEntry {
        private final int sortFieldType;
        private final Locale locale;
        private final Object readerKey;
        private final String fieldName;
        private final Class cacheType;
        private final Object custom;
        private final Object value;

        CacheEntryImpl(Object readerKey, String fieldName, Class cacheType, int sortFieldType, Object custom, Locale locale, Object value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.sortFieldType = sortFieldType;
            this.custom = custom;
            this.locale = locale;
            this.value = value;
        }

        public Object getReaderKey() {
            return this.readerKey;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class getCacheType() {
            return this.cacheType;
        }

        public Object getCustom() {
            return this.custom;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            String r = super.toString();
            if (null != this.locale) {
                r = r + "...!!!Locale:" + this.locale + "???";
            }
            if (9 != this.sortFieldType) {
                r = r + "...!!!SortType:" + this.sortFieldType + "???";
            }
            return r;
        }
    }
}

