/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.CommonFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedAnnotationDescriptor;
import org.apache.uima.tools.cfe.support.ComparableArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMAFeatureMatcher
extends CommonFeatureMatcher {
    Map<ComparableArray, String> m_featureImages;

    public UIMAFeatureMatcher(boolean includeTargetId) {
        super(includeTargetId, false, false, "|", new String[]{";", "^", "!", "%"});
    }

    @Override
    public void processJCas(JCas jcas) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        this.m_featureImages = new TreeMap<ComparableArray, String>();
        super.processJCas(jcas);
    }

    @Override
    protected void processFeatureGroup(JCas jcas, Annotation trg, String group_label, Collection<MatchedAnnotationDescriptor> features) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (MatchedAnnotationDescriptor mad : features) {
            ComparableArray key = new ComparableArray(new Integer[]{mad.m_feature_mv.getAnnotation().getEnd(), mad.m_feature_mv.getAnnotation().getBegin(), mad.m_orderIndex, this.m_featureImages.size()});
            String feature = this.make_UIMA_feature(mad, this.make_image(mad, trg));
            this.m_featureImages.put(key, group_label + this.m_fieldSeparator + feature);
        }
    }

    String make_UIMA_feature(MatchedAnnotationDescriptor mad, String other_fields) {
        StringBuilder stBuff = new StringBuilder();
        if (mad.m_feature_matcher.m_orientation || mad.m_feature_matcher.m_distance) {
            stBuff.append(UIMAFeatureMatcher.make_image_position(mad));
            stBuff.append(this.m_fieldSeparator);
        }
        stBuff.append(other_fields);
        return stBuff.toString();
    }
}

