/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.tools.cfe.BitsetFeatureValues;
import org.apache.uima.tools.cfe.EnumFeatureValues;
import org.apache.uima.tools.cfe.FeatureValues;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.ObjectPathFeatureValues;
import org.apache.uima.tools.cfe.PatternFeatureValues;
import org.apache.uima.tools.cfe.RangeFeatureValues;
import org.apache.uima.tools.cfe.TargetObjectMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFeatureMatcher {
    TargetObjectMatcher m_feature_matcher;
    FeatureValues m_feature_values;
    final boolean m_exclude;
    final boolean m_quiet;

    public SingleFeatureMatcher(String feat_class_name, String feat_full_path, boolean exclude, boolean quiet, FeatureValues fvals) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        this.m_feature_matcher = new TargetObjectMatcher(feat_class_name, feat_full_path, true);
        this.m_exclude = exclude;
        this.m_feature_values = fvals;
        this.m_quiet = quiet;
    }

    public SingleFeatureMatcher(String feat_class_name, String full_feat_path, boolean exclude, boolean quiet, Collection<String> values, boolean case_sensitive) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        this(feat_class_name, full_feat_path, exclude, quiet, new EnumFeatureValues(values, case_sensitive));
    }

    public SingleFeatureMatcher(String feat_class_name, String full_feat_path, boolean exclude, boolean quiet, String path, boolean case_sensitive) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException {
        this(feat_class_name, full_feat_path, exclude, quiet, new EnumFeatureValues(path, case_sensitive));
    }

    public SingleFeatureMatcher(String feat_class_name, String full_feat_path, boolean exclude, boolean quiet, Double lb, boolean lbi, Double ub, boolean ubi) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        this(feat_class_name, full_feat_path, exclude, quiet, new RangeFeatureValues(lb, lbi, ub, ubi));
    }

    public SingleFeatureMatcher(String feat_class_name, String full_feat_path, boolean exclude, boolean quiet, int bitmask, boolean exact_match) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        this(feat_class_name, full_feat_path, exclude, quiet, new BitsetFeatureValues(bitmask, exact_match));
    }

    public SingleFeatureMatcher(String feat_class_name, String full_feat_path, boolean exclude, boolean quiet, String pattern) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        this(feat_class_name, full_feat_path, exclude, quiet, new PatternFeatureValues(pattern));
    }

    public boolean matches(MatchedValue mv, List<MatchedValue> matchedValues) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<MatchedValue> vals = this.m_feature_matcher.getFeatureValues(mv);
        matchedValues.addAll(vals);
        Iterator<MatchedValue> it = vals.iterator();
        while (it.hasNext()) {
            if (!this.m_feature_values.matches(it.next().m_matchedObject)) continue;
            return !this.m_exclude;
        }
        return this.m_exclude;
    }

    void update(Object source) throws IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        if (this.m_feature_values instanceof ObjectPathFeatureValues) {
            ((ObjectPathFeatureValues)this.m_feature_values).update(source, null, null);
        }
    }
}

