/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import org.apache.uima.tools.cfe.FeatureValues;

public class RangeFeatureValues
implements FeatureValues {
    Double m_lower_boundary;
    boolean m_lower_boundary_inclusive;
    Double m_upper_boundary;
    boolean m_upper_boundary_inclusive;

    public RangeFeatureValues(double lb, boolean lbi, double ub, boolean ubi) {
        this.m_lower_boundary = lb;
        this.m_lower_boundary_inclusive = lbi;
        this.m_upper_boundary = ub;
        this.m_upper_boundary_inclusive = ubi;
    }

    public boolean matches(Object feature) {
        if (!(feature instanceof Number)) {
            return false;
        }
        Number nfeature = (Number)feature;
        int lb_res = this.m_lower_boundary.compareTo(nfeature.doubleValue());
        if (0 == lb_res && !this.m_lower_boundary_inclusive || lb_res < 0) {
            return false;
        }
        int ub_res = this.m_upper_boundary.compareTo(nfeature.doubleValue());
        return (0 != ub_res || this.m_upper_boundary_inclusive) && ub_res <= 0;
    }

    public String getFeatureImage(Object feature) {
        return feature.toString();
    }
}

