/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.AppliedAnnotation;
import org.apache.uima.tools.cfe.ApplierInfoAnnotation;
import org.apache.uima.tools.cfe.CommonFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedAnnotationDescriptor;
import org.apache.uima.tools.cfe.SenseAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRMFeatureMatcher
extends CommonFeatureMatcher {
    public static final String PARAM_INCLUDEFEATUREWINDOWIMAGE = "IncludeFeatureWindowImage";
    final boolean m_isFeatureWindowImage;

    public RRMFeatureMatcher(boolean includeAnnotationName, boolean includeFeatureName, boolean isFeatureWindowImage) {
        super(false, includeAnnotationName, includeFeatureName, "_", new String[]{"_"});
        this.m_isFeatureWindowImage = isFeatureWindowImage;
    }

    protected String featureWindowImage(MatchedAnnotationDescriptor mad) {
        StringBuilder buf = new StringBuilder("W");
        if (mad.m_feature_matcher.m_windowsizeLeft > 0) {
            buf.append("L" + mad.m_feature_matcher.m_windowsizeLeft);
        }
        if (mad.m_feature_matcher.m_windowsizeInside > 0) {
            buf.append("I" + mad.m_feature_matcher.m_windowsizeInside);
        }
        if (mad.m_feature_matcher.m_windowsizeRight > 0) {
            buf.append("R" + mad.m_feature_matcher.m_windowsizeRight);
        }
        if (mad.m_feature_matcher.m_windowsizeEnclosed > 0) {
            String[] name_toks = mad.m_enclosing.getClass().getName().split("\\.");
            buf.append(name_toks[name_toks.length - 1]);
        }
        if (mad.m_feature_matcher.m_windowFlags > 0) {
            buf.append("F" + mad.m_feature_matcher.m_windowFlags);
        }
        return buf.toString();
    }

    @Override
    protected void processFeatureGroup(JCas jcas, Annotation trg, String class_label, Collection<MatchedAnnotationDescriptor> features) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeSet<String> featureImages = new TreeSet<String>();
        for (MatchedAnnotationDescriptor mad : features) {
            String feature = this.make_RRM_feature(mad, this.make_image(mad, trg));
            if (this.m_isFeatureWindowImage) {
                feature = this.featureWindowImage(mad) + this.m_fieldSeparator + feature;
            }
            featureImages.add(feature);
        }
        StringArray uima_feats = new StringArray(jcas, featureImages.size());
        int ind = 0;
        Iterator img_it = featureImages.iterator();
        while (img_it.hasNext()) {
            uima_feats.set(ind++, (String)img_it.next());
        }
        SenseAnnotation sa = new SenseAnnotation(jcas, trg.getBegin(), trg.getEnd());
        sa.setSENSE(class_label);
        AppliedAnnotation aa = new AppliedAnnotation(jcas, trg.getBegin(), trg.getEnd());
        aa.setTruth(sa);
        ApplierInfoAnnotation aia = new ApplierInfoAnnotation(jcas, trg.getBegin(), trg.getEnd());
        aia.setDocumentId(RRMFeatureMatcher.getDocumentId(jcas, aia));
        aia.setAppliedAnnotation(aa);
        aia.setFeatures(uima_feats);
        aia.addToIndexes();
    }

    private String make_RRM_feature(MatchedAnnotationDescriptor mad, String suffix) {
        if (suffix.indexOf(" ") >= 0) {
            System.err.println("ERROR: \"" + suffix + "\"" + "has spaces");
        }
        StringBuilder feature = new StringBuilder();
        Pattern pat = Pattern.compile("\\W");
        Matcher mat = pat.matcher(suffix);
        int start = 0;
        while (mat.find()) {
            int gstart = mat.start();
            feature.append(suffix.substring(start, gstart));
            start = mat.end();
            StringBuilder replaced = new StringBuilder();
            String group = mat.group();
            for (int i = 0; i < group.length(); ++i) {
                replaced.append("__CHAR" + group.charAt(i) + "__");
            }
            feature.append((CharSequence)replaced);
        }
        feature.append(suffix.substring(start));
        StringBuilder strBuf = new StringBuilder();
        if (mad.m_feature_matcher.m_orientation || mad.m_feature_matcher.m_distance) {
            strBuf.append(RRMFeatureMatcher.make_image_position(mad));
            strBuf.append(this.m_fieldSeparator);
        }
        strBuf.append((CharSequence)feature);
        return strBuf.toString();
    }
}

