/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.tools.cfe.GroupFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedSingleFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialObjectMatcher {
    Class<?> m_matcher_class;
    String m_full_path;
    Collection<GroupFeatureMatcher> m_group_feature_matchers = new ArrayList<GroupFeatureMatcher>();

    public PartialObjectMatcher(String class_name, String full_path, Collection<GroupFeatureMatcher> gfms) throws ClassNotFoundException {
        this.m_matcher_class = Class.forName(class_name);
        this.m_full_path = null == full_path || 0 == full_path.length() ? this.m_matcher_class.getName() : full_path;
        if (null != gfms) {
            this.m_group_feature_matchers.addAll(gfms);
        }
    }

    protected PartialObjectMatcher(String class_name, String full_annotation_path) throws ClassNotFoundException {
        this(class_name, full_annotation_path, new ArrayList<GroupFeatureMatcher>());
    }

    String getObjectPath() {
        return this.m_full_path;
    }

    public void addGroupMatcher(GroupFeatureMatcher gfm) {
        this.m_group_feature_matchers.add(gfm);
    }

    public boolean matches(MatchedValue mv, Collection<MatchedSingleFeatureMatcher> matched) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this.m_matcher_class.isAssignableFrom(mv.m_matchedObject.getClass())) {
            return false;
        }
        if (this.m_group_feature_matchers.isEmpty()) {
            return true;
        }
        for (GroupFeatureMatcher gfm : this.m_group_feature_matchers) {
            ArrayList<MatchedSingleFeatureMatcher> grp_matched;
            if (!gfm.matches(mv, grp_matched = new ArrayList<MatchedSingleFeatureMatcher>())) continue;
            matched.addAll(grp_matched);
            return true;
        }
        return false;
    }

    void update(Object source) throws IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        Iterator<GroupFeatureMatcher> it = this.m_group_feature_matchers.iterator();
        while (it.hasNext()) {
            it.next().update(source);
        }
    }

    public Class<?> getMatcherClass() {
        return this.m_matcher_class;
    }
}

