/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetDiff {
    public String m_source_id;
    public String m_target_id;

    public OffsetDiff(String source_id, String target_id) {
        this.m_source_id = source_id;
        this.m_target_id = target_id;
    }

    private static int nextSpanInd(Collection<Span> spans, int curr) {
        if (curr < spans.size()) {
            return curr + 1;
        }
        return curr;
    }

    private void print(Span source, Span target) {
        String m = null;
        m = null == source ? target.printNullImage() : source.printImage();
        m = m + "|";
        m = null == target ? m + source.printNullImage() : m + target.printImage();
        m = m + "|" + this.m_source_id + "|" + this.m_target_id;
        System.out.println(m);
    }

    public void process(List<Span> source, List<Span> target) {
        this.findEqual(source, target);
        int trg_ind = 0;
        int src_ind = 0;
        Span sspan = null;
        Span tspan = null;
        ArrayList<Span> smatched = new ArrayList<Span>();
        ArrayList<Span> tmatched = new ArrayList<Span>();
        while (src_ind < source.size() || trg_ind < target.size()) {
            int curr_state = -1;
            if (src_ind < source.size()) {
                sspan = source.get(src_ind);
            }
            if (trg_ind < target.size()) {
                tspan = target.get(trg_ind);
            }
            if (src_ind < source.size() && trg_ind < target.size()) {
                curr_state = sspan.compare(tspan);
            } else if (trg_ind >= target.size()) {
                curr_state = 6;
            } else if (src_ind >= source.size()) {
                curr_state = 5;
            }
            switch (curr_state) {
                case 1: {
                    this.print(sspan, tspan);
                    trg_ind = OffsetDiff.nextSpanInd(target, trg_ind);
                    src_ind = OffsetDiff.nextSpanInd(source, src_ind);
                    tmatched.add(tspan);
                    smatched.add(sspan);
                    break;
                }
                case 2: {
                    this.print(sspan, tspan);
                    trg_ind = OffsetDiff.nextSpanInd(target, trg_ind);
                    src_ind = OffsetDiff.nextSpanInd(source, src_ind);
                    tmatched.add(tspan);
                    smatched.add(sspan);
                    break;
                }
                case 3: {
                    this.print(sspan, tspan);
                    src_ind = OffsetDiff.nextSpanInd(source, src_ind);
                    trg_ind = OffsetDiff.nextSpanInd(target, trg_ind);
                    tmatched.add(tspan);
                    smatched.add(sspan);
                    break;
                }
                case 4: {
                    this.print(sspan, tspan);
                    src_ind = OffsetDiff.nextSpanInd(source, src_ind);
                    trg_ind = OffsetDiff.nextSpanInd(target, trg_ind);
                    tmatched.add(tspan);
                    smatched.add(sspan);
                    break;
                }
                case 5: {
                    this.print(null, tspan);
                    trg_ind = OffsetDiff.nextSpanInd(target, trg_ind);
                    tmatched.add(tspan);
                    break;
                }
                case 6: {
                    this.print(sspan, null);
                    src_ind = OffsetDiff.nextSpanInd(source, src_ind);
                    smatched.add(sspan);
                }
            }
        }
        source.removeAll(smatched);
        target.removeAll(tmatched);
        if (!source.isEmpty() || !target.isEmpty()) {
            System.err.println("ERROR: comparison incomplete. source:" + source.size() + ", target:" + target.size());
        }
    }

    void findEqual(List<Span> source, List<Span> target) {
        int trg_ind = 0;
        Span sspan = null;
        Span tspan = null;
        ArrayList<Span> smatched = new ArrayList<Span>();
        ArrayList<Span> tmatched = new ArrayList<Span>();
        block0: for (int i = 0; i < source.size(); ++i) {
            sspan = source.get(i);
            for (int j = trg_ind; j < target.size(); ++j) {
                tspan = target.get(j);
                int curr_state = sspan.compare(tspan);
                if (0 == curr_state) {
                    this.print(sspan, tspan);
                    trg_ind = j + 1;
                    smatched.add(sspan);
                    tmatched.add(tspan);
                    continue block0;
                }
                if (6 == curr_state) continue block0;
            }
        }
        source.removeAll(smatched);
        target.removeAll(tmatched);
    }

    private static List<Span> readSpannedFile(String filename) throws FileNotFoundException {
        String line = null;
        ArrayList<Span> result = new ArrayList<Span>();
        File fs = new File(filename);
        if (fs.exists()) {
            int cnt = 0;
            try {
                BufferedReader in = new BufferedReader(new FileReader(fs));
                while (null != (line = in.readLine())) {
                    Span s;
                    ++cnt;
                    if (line.startsWith("#") || null == (s = new Span(line))) continue;
                    result.add(s);
                }
                in.close();
            }
            catch (IOException e) {
                System.err.println(filename + ": failed to read " + cnt + " line");
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        if (2 != args.length) {
            System.err.println("Usage: com.ibm.medtas.common source_file target_file");
            return;
        }
        OffsetDiff od = new OffsetDiff(args[0], args[1]);
        List<Span> source = OffsetDiff.readSpannedFile(args[0]);
        List<Span> target = OffsetDiff.readSpannedFile(args[1]);
        od.process(source, target);
    }

    static class Span {
        public String[] m_toks;
        public int m_begin;
        public int m_end;
        public int m_printed;
        public static final int COMPARE_NONE = -1;
        public static final int COMPARE_EQUAL = 0;
        public static final int COMPARE_CONTAINS = 1;
        public static final int COMPARE_BELONGS = 2;
        public static final int COMPARE_AHEAD = 3;
        public static final int COMPARE_BEHIND = 4;
        public static final int COMPARE_FARAHEAD = 5;
        public static final int COMPARE_FARBEHIND = 6;

        public Span(String line) {
            String CONSTANT_EOL_NULL = "CONSTANT_EOL_NULL";
            if (line.endsWith("|")) {
                line = line + "CONSTANT_EOL_NULL";
            }
            this.m_toks = line.split("\\|");
            if ("CONSTANT_EOL_NULL".equals(this.m_toks[this.m_toks.length - 1])) {
                this.m_toks[this.m_toks.length - 1] = "";
            }
            this.m_begin = Integer.parseInt(this.m_toks[0]);
            this.m_end = Integer.parseInt(this.m_toks[1]);
        }

        int getBegin() {
            return this.m_begin;
        }

        int getEnd() {
            return this.m_end;
        }

        public int printed() {
            return this.m_printed;
        }

        public String printImage() {
            ++this.m_printed;
            StringBuilder image = new StringBuilder(this.m_toks[0] + "|" + this.m_toks[1]);
            for (int i = 2; i < this.m_toks.length; ++i) {
                image.append("|");
                image.append(this.m_toks[i]);
            }
            return image.toString();
        }

        String printNullImage() {
            StringBuilder image = new StringBuilder("|");
            for (int i = 2; i < this.m_toks.length; ++i) {
                image.append("|");
            }
            return image.toString();
        }

        public int compare(Span other) {
            if (this.getBegin() == other.getBegin() && this.getEnd() == other.getEnd()) {
                return 0;
            }
            if (this.getBegin() <= other.getBegin() && this.getEnd() >= other.getEnd()) {
                return 1;
            }
            if (this.getBegin() >= other.getBegin() && this.getEnd() <= other.getEnd()) {
                return 2;
            }
            if (this.getBegin() < other.getBegin() && this.getEnd() > other.getBegin() && this.getEnd() < other.getEnd()) {
                return 4;
            }
            if (this.getBegin() > other.getBegin() && other.getEnd() > this.getBegin() && this.getEnd() > other.getEnd()) {
                return 3;
            }
            if (this.getBegin() > other.getBegin() && this.getBegin() >= other.getEnd()) {
                return 5;
            }
            if (this.getBegin() < other.getBegin() && this.getEnd() <= other.getBegin()) {
                return 6;
            }
            return -1;
        }
    }
}

