/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.bsf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.annotator.bsf.BSFAnnotatorConfigurationException;
import org.apache.uima.annotator.bsf.BSFAnnotatorInitializationException;
import org.apache.uima.annotator.bsf.BSFAnnotatorProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSFAnnotator
extends JCasAnnotator_ImplBase {
    public static final String MESSAGE_DIGEST = "org.apache.uima.annotator.bsf.BSFAnnotatorMessages";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String SCRIPT_SOURCE_FILE = "SourceFile";
    private Logger logger;
    private BSFManager manager;
    private BSFEngine engine;
    String scriptLanguage;
    String scriptFileName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        Throwable cause;
        super.initialize(aContext);
        this.manager = new BSFManager();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.manager.setClassLoader(classLoader);
        if (classLoader instanceof URLClassLoader) {
            this.manager.setClassPath(this.classpathFromUrls(((URLClassLoader)classLoader).getURLs()));
        }
        FileReader reader = null;
        this.scriptFileName = null;
        try {
            this.logger = aContext.getLogger();
            StringTokenizer tokenizer = new StringTokenizer(aContext.getDataPath(), PATH_SEPARATOR);
            ArrayList<File> datapathElements = new ArrayList<File>();
            while (tokenizer.hasMoreTokens()) {
                datapathElements.add(new File(tokenizer.nextToken()));
            }
            this.scriptFileName = (String)aContext.getConfigParameterValue(SCRIPT_SOURCE_FILE);
            File scriptFile = new File(this.scriptFileName);
            if (!scriptFile.isAbsolute() && (scriptFile = this.resolveRelativeFilePath(this.scriptFileName, datapathElements)) == null) {
                throw new BSFAnnotatorConfigurationException("bsf_annotator_resource_not_found", new Object[]{this.scriptFileName});
            }
            reader = new FileReader(scriptFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new BSFAnnotatorConfigurationException("bsf_annotator_resource_not_found", new Object[]{this.scriptFileName}, fnfe);
        }
        try {
            this.scriptLanguage = BSFManager.getLangFromFilename((String)this.scriptFileName);
            this.engine = this.manager.loadScriptingEngine(this.scriptLanguage);
        }
        catch (BSFException bsfe) {
            cause = bsfe.getTargetException();
            if (cause == null) {
                cause = bsfe;
            }
            throw new BSFAnnotatorConfigurationException("bsf_annotator_language_not_supported", new Object[]{this.scriptLanguage}, cause);
        }
        try {
            String script = IOUtils.getStringFromReader((Reader)reader);
            this.engine.exec(this.scriptFileName, 0, 0, (Object)script);
        }
        catch (IOException ioe) {
            throw new BSFAnnotatorInitializationException("bsf_annotator_error_reading_script", new Object[]{this.scriptFileName}, ioe);
        }
        catch (BSFException bsfe) {
            cause = bsfe.getTargetException();
            if (cause == null) {
                cause = bsfe;
            }
            throw new BSFAnnotatorInitializationException("bsf_annotator_error_executing_script", new Object[]{this.scriptFileName}, cause);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
        String methodName = null;
        try {
            methodName = "initialize";
            this.engine.call(null, methodName, new Object[]{aContext});
        }
        catch (BSFException bsfe) {
            Throwable cause2 = bsfe.getTargetException();
            if (cause2 == null) {
                cause2 = bsfe;
            }
            throw new BSFAnnotatorInitializationException("bsf_annotator_error_calling_method", new Object[]{methodName}, cause2);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String methodName = null;
        try {
            methodName = "process";
            this.engine.call(null, methodName, new Object[]{jcas});
        }
        catch (BSFException bsfe) {
            Throwable cause = bsfe.getTargetException();
            if (cause == null) {
                cause = bsfe;
            }
            throw new BSFAnnotatorProcessException("bsf_annotator_error_calling_method", new Object[]{methodName}, cause);
        }
    }

    private File resolveRelativeFilePath(String fileName, List<File> datapathElements) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName);
        if (url != null) {
            URI uri;
            try {
                uri = BSFAnnotator.quote(url);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null) {
                return new File(uri);
            }
        }
        if (datapathElements == null || datapathElements.size() == 0) {
            return null;
        }
        for (File dataPathDir : datapathElements) {
            File testFile = new File(dataPathDir, fileName);
            if (!testFile.exists()) continue;
            return testFile;
        }
        return null;
    }

    private String classpathFromUrls(URL[] urls) {
        String classpath = null;
        for (int i = 0; i < urls.length; ++i) {
            File filepath = new File(urls[i].getPath());
            classpath = i == 0 ? filepath.getPath() : classpath + File.pathSeparator + filepath.getPath();
        }
        return classpath;
    }

    private static URI quote(String s) throws URISyntaxException {
        if (-1 == s.indexOf(37)) {
            return new URI(null, s, null);
        }
        return new URI(s);
    }

    private static URI quote(URL u) throws URISyntaxException {
        return BSFAnnotator.quote(u.toString());
    }
}

