/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.simpleserver.Service;
import org.apache.uima.simpleserver.config.Output;
import org.apache.uima.simpleserver.config.ServerSpec;
import org.apache.uima.simpleserver.config.TypeMap;
import org.apache.uima.simpleserver.output.Result;
import org.apache.uima.simpleserver.output.ResultConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServerServlet
extends HttpServlet {
    public static final String utf8 = "utf-8";
    public static final String MODE_PARAMETER = "mode";
    public static final String DEFAULT_CODE_PAGE = "utf-8";
    public File baseWebappDirectory = null;
    public Service server = null;
    protected boolean initializationSuccessful = false;
    private Logger logger = Logger.getAnonymousLogger();
    protected Map<String, String> servletGETParameters;
    protected Map<String, String> servletPOSTParameters;
    protected Map<String, Map<String, String>> servletGETParamOptions;
    protected Map<String, Map<String, String>> servletPOSTParamOptions;
    private final boolean localInit;

    public SimpleServerServlet(boolean localInit) {
        this.localInit = localInit;
        this.servletGETParameters = new HashMap<String, String>();
        this.servletPOSTParameters = new HashMap<String, String>();
        this.servletGETParamOptions = new HashMap<String, Map<String, String>>();
        this.servletPOSTParamOptions = new HashMap<String, Map<String, String>>();
    }

    public SimpleServerServlet() {
        this(false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void declareServletParameters() {
        this.servletGETParameters.put(MODE_PARAMETER, "This parameter should define, what the servlet should return. Some options are available.");
        HashMap<String, String> options = new HashMap<String, String>();
        this.servletGETParamOptions.put(MODE_PARAMETER, options);
        options.put("description", "will return a description of a service in  HTML (human-readable) format. This description is partially automatically generated, and partially created by the author of this service.");
        options.put("xsd", "will return a XSD schema definition of the text analysis results");
        options.put("form", "will show a form with input fields, which will allow you to try out this service");
        options.put("xmldesc", "will show a specification of this service in XML format");
        this.servletPOSTParameters.put("text", "the value of this parameter is the text to analyze. Expected encoding is UTF-8. This parameter must always be set.");
        this.servletPOSTParameters.put(MODE_PARAMETER, "This parameter should define, what view of the analyss result the servlet should return. If this parameter is not set, XML output will be produced.");
        options = new HashMap();
        options.put("xml", "means to output the result as a XML-document containing a list of found entities");
        options.put("inline", "returns inline-xml containing the analyzed text in which all found entities are represented by tags");
        this.servletPOSTParamOptions.put(MODE_PARAMETER, options);
        this.servletPOSTParameters.put("lang", "This parameter sets the language of the text. If this parameter is not set, the value&quot;en&quot; will be used");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.initializationSuccessful) {
            response.sendError(500, "The service is currently unavailable due to internal errors.\nPlease contact the service provider.");
            return;
        }
        response.setCharacterEncoding("utf-8");
        request.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        if (request.getParameterMap().isEmpty()) {
            writer.print(this.constructHtmlDescription(request.getRequestURL().toString()));
            writer.close();
            return;
        }
        String mode = request.getParameter(MODE_PARAMETER);
        try {
            if ("xsd".equals(mode)) {
                response.setHeader("content-type", "text/xml");
                writer.println(this.server.getXMLResultXSD());
                writer.close();
            } else if ("description".equals(mode)) {
                response.setHeader("content-type", "text/html");
                writer.print(this.constructHtmlDescription(request.getRequestURL().toString()));
                writer.close();
            } else if ("form".equals(mode)) {
                response.setHeader("content-type", "text/html");
                writer.print(this.getHtmlForm(request.getRequestURL().toString()));
                writer.close();
            } else if ("xmldesc".equals(mode)) {
                response.setHeader("content-type", "text/xml");
                writer.print(this.server.getServiceDescription());
                writer.close();
            } else {
                response.setHeader("content-type", "text/xml");
                this.analyze(request, response);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "An error occured processing this request", e);
            response.sendError(500, "An internal error occured, this service has not been properly initialized.");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("content-type", "text/xml");
        this.analyze(request, response);
    }

    protected void analyze(HttpServletRequest request, HttpServletResponse response) throws IOException {
        System.out.println(((Object)((Object)this)).getClass().getName() + ": POST request received: " + new Date());
        request.setCharacterEncoding("utf-8");
        response.setCharacterEncoding("utf-8");
        String text = request.getParameter("text");
        String lang = request.getParameter("lang");
        System.out.println("Given text: " + text.substring(0, Math.min(50, text.length())));
        String mode = request.getParameter(MODE_PARAMETER);
        if (lang == null || lang.equals("")) {
            lang = "en";
        }
        System.out.println("mode: " + mode);
        System.out.println("lang: " + lang);
        Result result = this.server.process(text, lang);
        PrintWriter writer = response.getWriter();
        writer.write(this.transformResult(result, mode));
        writer.close();
    }

    public void init() throws ServletException {
        System.out.println("Starting UIMA servlet initialization");
        if (this.localInit) {
            return;
        }
        super.init();
        System.out.println("Servlet " + ((Object)((Object)this)).getClass().getCanonicalName() + " -- initialisation begins");
        this.baseWebappDirectory = new File(this.getServletContext().getRealPath(""));
        this.server = new Service();
        this.initializationSuccessful = this.initServer();
        this.declareServletParameters();
    }

    public void init(File descriptorFile, File serviceSpecFile) throws ServletException {
        super.init();
        this.initializationSuccessful = false;
        this.server = new Service();
        try {
            this.server.configureAnalysisEngine(descriptorFile, serviceSpecFile);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "UIMA Simple Service configuaration failed", e);
            return;
        }
        this.declareServletParameters();
        this.initializationSuccessful = true;
    }

    protected boolean initServer() {
        File resultSpec = null;
        String resultSpecParamValue = this.getInitParameter("ResultSpecFile");
        if (resultSpecParamValue != null) {
            resultSpec = new File(this.baseWebappDirectory.getAbsoluteFile(), resultSpecParamValue);
        }
        String pearPath = this.getInitParameter("PearPath");
        String descriptorPath = this.getInitParameter("DescriptorPath");
        String pearInstallPath = this.getInitParameter("PearInstallPath");
        try {
            if (pearPath == null) {
                File descriptor = new File(this.baseWebappDirectory.getAbsoluteFile(), descriptorPath);
                this.server.configureAnalysisEngine(descriptor, resultSpec);
            } else if (descriptorPath == null) {
                File pear = new File(this.baseWebappDirectory.getAbsoluteFile(), pearPath);
                File pearInstallDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (pearInstallPath != null && !(pearInstallDir = new File(pearInstallPath)).isAbsolute()) {
                    pearInstallDir = new File(pear.getParentFile(), pearInstallPath);
                }
                this.getLogger().log(Level.INFO, "Install PEAR file to: " + pearInstallDir.getAbsolutePath());
                this.server.configurePear(pear, pearInstallDir, resultSpec);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "UIMA Simple Service configuaration failed", e);
            return false;
        }
        return true;
    }

    public String transformResult(Result result, String mode) {
        if ("xml".equals(mode)) {
            return ResultConverter.getXMLString(result);
        }
        if ("inline".equals(mode)) {
            return ResultConverter.getInlineXML(result);
        }
        return ResultConverter.getXMLString(result);
    }

    public String getCustomDescription() {
        return "";
    }

    public String constructHtmlDescription(String servletURL) {
        ServerSpec rspec = this.server.getServiceSpec();
        String html = "<html><head><title>" + rspec.getShortDescription() + "</title>" + "</head>" + "<body>" + "<h2>" + rspec.getShortDescription() + "</h2>" + rspec.getLongDescription() + "<h3>Usage</h3>" + "In order to use this service, a POST- or GET-request should be sent to the server with the following URL:" + "<pre>" + servletURL + "</pre>" + "<br/>" + "The following request parameters are expected:" + this.constructParameterDescription() + "<h3>Result</h3>" + "If XML or inline-XML output is requested, it will contain the tags listed below. " + "The XSD-definition of the output in XML-format can be downloaded " + "<a href=\"" + servletURL + "?mode=xsd\">here</a>." + this.constructResultDescription() + "" + (this.getCustomDescription().equals("") ? "" : "<h3>Additional description </h3> " + this.getCustomDescription()) + "" + "<h3>Example of usage</h3>" + "<pre>" + "String text = \"Hello Mr. John Smith !\"; \n" + "String parameters = \"text=\" + URLEncoder.encode(text, \"UTF-8\") + \"&mode=inline\";\n" + "URL url = new URL(\"" + servletURL + "\"); \n" + "URLConnection connection = url.openConnection(); \n" + "connection.setDoOutput(true); \n" + "OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream()); \n" + "writer.write(parameters);\n" + "writer.flush(); \n\n" + "BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), \"UTF-8\")); \n" + "String line; \n" + "while ((line = reader.readLine()) != null) { \n" + "    System.out.println(line);\n" + "} \n" + "</pre>" + "<body>" + "</html>";
        return html;
    }

    public String constructParameterDescription() {
        String s = "";
        s = s + "<h3>POST-parameters</h3> POST request should be sent to use the service";
        s = s + this.parameterDescription(this.servletPOSTParameters, this.servletPOSTParamOptions);
        s = s + "<h3>GET-parameters</h3> GET request should be sent to obtain information about the service";
        s = s + this.parameterDescription(this.servletGETParameters, this.servletGETParamOptions);
        return s;
    }

    public String parameterDescription(Map<String, String> params, Map<String, Map<String, String>> options) {
        String s = "";
        s = s + "<ul>";
        for (String param : params.keySet()) {
            String desc = params.get(param);
            s = s + "<li/> ";
            s = s + "<b>" + param + "</b> " + " -- " + desc;
            Map<String, String> opts = options.get(param);
            if (opts == null) continue;
            s = s + "<ul>";
            s = s + "Possible values: <br/>";
            for (String opt : opts.keySet()) {
                s = s + "<li/> ";
                s = s + "<b>" + opt + "</b> " + " -- " + opts.get(opt);
            }
            s = s + "</ul>";
        }
        s = s + "</ul>";
        return s;
    }

    public String constructResultDescription() {
        String s = "";
        try {
            s = s + "<h4>XML elemets of result</h4>";
            s = s + "<ul>";
            for (TypeMap t : this.server.getServiceSpec().getTypeSpecs()) {
                s = s + "<li/>";
                s = s + "Element <b>" + t.getOutputTag() + "</b> -- " + t.getShortDescription();
                s = s + "<br/> " + t.getLongDescription();
                s = s + "<ul>";
                s = s + "Attributes: <br/>";
                for (Output o : t.getOutputs()) {
                    s = s + "<li/>";
                    s = s + "Attribute <b>" + o.getAttribute() + "</b> -- " + o.getShortDescription();
                    s = s + "<br/> " + o.getLongDescription();
                }
                s = s + "</ul>";
                s = s + "<br/>";
            }
            s = s + "</ul>";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public String getHtmlForm(String serverUrl) {
        String str = "<html><head><title>" + serverUrl + " tryout form " + "</title>" + "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" >" + "</head>" + "<body>" + "<h2>Tryout form of " + serverUrl + "</h2>" + "<form method=\"post\"  action=\"" + serverUrl + "\">" + "Enter text: <br/>" + "<textarea name=\"text\" rows=\"25\" cols=\"80\"></textarea><br/>" + "Enter language(optional):<br/>" + "<input type=\"text\" name=\"lang\" /><br/>" + "Display result as<br/>" + "<input type=\"radio\" name=\"mode\" value=\"xml\" checked=\"checked\"/> XML document <br/>" + "<input type=\"radio\" name=\"mode\" value=\"inline\"/> inline XML <br/>" + "" + "" + "" + "" + "" + "" + "" + "" + "<input type=\"submit\">" + "</form>" + "</body>" + "</html>";
        return str;
    }
}

