/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.uima.simpleserver.output.ResultEntry;
import org.apache.uima.simpleserver.output.impl.ResultEntryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceReaderThread
extends Thread {
    private Collection<ResultEntry> resultEntries = null;
    private String url = null;
    private String text = null;
    private String lang = null;

    public ServiceReaderThread(String url, String text, String lang) {
        this.url = url;
        this.text = text;
        this.lang = lang;
        this.resultEntries = new LinkedList<ResultEntry>();
    }

    @Override
    public void run() {
        try {
            DocumentBuilderFactory factory = null;
            DocumentBuilder builder = null;
            try {
                factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            BufferedReader reader = this.readUrl(this.url, this.text, this.lang);
            InputSource source = new InputSource(reader);
            Document document = builder.parse(source);
            this.insertResults(document, this.resultEntries);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private BufferedReader readUrl(String urlStr, String text1, String lang1) throws IOException {
        String parameter = URLEncoder.encode("text", "UTF-8") + "=" + URLEncoder.encode(text1, "UTF-8") + "&mode=xml" + "&lang=" + lang1;
        URL url1 = new URL(urlStr);
        URLConnection connection = url1.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(parameter);
        writer.close();
        return new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
    }

    public Collection<ResultEntry> getResultEntries() {
        return this.resultEntries;
    }

    private void insertResults(Document document, Collection<ResultEntry> resultEntries1) {
        Element root = document.getDocumentElement();
        NodeList resultElements = root.getChildNodes();
        int l = resultElements.getLength();
        for (int i = 0; i < l; ++i) {
            if (!(resultElements.item(i) instanceof Element)) continue;
            Element element = (Element)resultElements.item(i);
            ResultEntryImpl entry = new ResultEntryImpl(element.getNodeName(), 0, 0);
            NamedNodeMap attributes = element.getAttributes();
            int k = attributes.getLength();
            for (int x = 0; x < k; ++x) {
                Node attribute = attributes.item(x);
                if (attribute.getNodeName() == null || attribute.getNodeValue() == null) continue;
                entry.setAttributeValue(attribute.getNodeName(), attribute.getNodeValue());
            }
            entry.setCoveredText(element.getTextContent());
            resultEntries1.add(entry);
        }
    }
}

