/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.output;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.simpleserver.output.InlineXMLGenerator;
import org.apache.uima.simpleserver.output.Result;
import org.apache.uima.simpleserver.output.ResultEntry;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ResultConverter {
    public static String getXMLString(Result result) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document document = impl.createDocument(null, null, null);
            Element root = document.createElement("result");
            document.appendChild(root);
            for (ResultEntry resultEntry : result.getResultEntries()) {
                Element element = document.createElement(resultEntry.getEntryName());
                root.appendChild(element);
                for (String attributeName : resultEntry.getAttributeNames()) {
                    String attributeValue = resultEntry.getAttriuteValue(attributeName);
                    element.setAttribute(attributeName, attributeValue);
                }
                if (resultEntry.getCoveredText() == null) continue;
                Text textNode = document.createTextNode(resultEntry.getCoveredText());
                element.appendChild(textNode);
            }
            DOMSource source = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(source, streamResult);
            return stringWriter.toString().replace(" standalone=\"no\"", "");
        }
        catch (Throwable t) {
            throw new RuntimeException("XML output failed", t);
        }
    }

    public static String getInlineXML(Result result) {
        try {
            return InlineXMLGenerator.getInlineXML(result);
        }
        catch (Throwable t) {
            throw new RuntimeException("Tagged text output failed", t);
        }
    }
}

