/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.config.impl;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.simpleserver.config.Condition;
import org.apache.uima.simpleserver.config.Filter;
import org.apache.uima.simpleserver.config.FilterOp;
import org.apache.uima.simpleserver.config.SimpleFilter;
import org.apache.uima.simpleserver.config.impl.FilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFilterImpl
extends FilterImpl
implements SimpleFilter {
    private final List<String> path;
    private final Condition condition;

    private SimpleFilterImpl() {
        this(null, null);
    }

    public SimpleFilterImpl(List<String> path, Condition condition) {
        super(Filter.FilterType.SIMPLE);
        this.path = path;
        this.condition = condition;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public List<String> getFeaturePath() {
        return Collections.unmodifiableList(this.path);
    }

    @Override
    public boolean match(FeatureStructure fs) {
        Stack<String> stack = SimpleFilterImpl.list2Stack(this.path);
        return this.match(stack, fs);
    }

    private final boolean match(Stack<String> stack, FeatureStructure fs) {
        if (stack.isEmpty()) {
            switch (this.getCondition().getConditionType()) {
                case NULL: {
                    return fs == null;
                }
                case NOT_NULL: {
                    return fs != null;
                }
            }
            return false;
        }
        if (fs == null) {
            return false;
        }
        String fName = stack.pop();
        Feature f = fs.getType().getFeatureByBaseName(fName);
        if (f == null) {
            return false;
        }
        Type range = f.getRange();
        int typeClass = TypeSystemUtils.classifyType((Type)range);
        if (typeClass == 8) {
            fs = fs.getFeatureValue(f);
            return this.match(stack, fs);
        }
        if (!stack.isEmpty()) {
            return false;
        }
        switch (typeClass) {
            case 9: {
                return this.checkBoolean(fs.getBooleanValue(f));
            }
            case 10: {
                return this.checkByte(fs.getByteValue(f));
            }
            case 13: {
                return this.checkDouble(fs.getDoubleValue(f));
            }
            case 2: {
                return this.checkFloat(fs.getFloatValue(f));
            }
            case 1: {
                return this.checkInt(fs.getIntValue(f));
            }
            case 12: {
                return this.checkLong(fs.getLongValue(f));
            }
            case 11: {
                return this.checkShort(fs.getShortValue(f));
            }
            case 3: {
                return this.checkString(fs.getStringValue(f));
            }
        }
        return false;
    }

    private final boolean checkByte(byte in) {
        byte v;
        String value = this.getCondition().getValue();
        try {
            v = Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkDouble(double in) {
        double v;
        String value = this.getCondition().getValue();
        try {
            v = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkFloat(float in) {
        float v;
        String value = this.getCondition().getValue();
        try {
            v = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkLong(long in) {
        long v;
        String value = this.getCondition().getValue();
        try {
            v = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkInt(int in) {
        int v;
        String value = this.getCondition().getValue();
        try {
            v = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkShort(short in) {
        short v;
        String value = this.getCondition().getValue();
        try {
            v = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return in == v;
            }
            case NOT_EQUALS: {
                return in != v;
            }
            case GREATER: {
                return in > v;
            }
            case GREATER_EQ: {
                return in >= v;
            }
            case LESS: {
                return in < v;
            }
            case LESS_EQ: {
                return in <= v;
            }
        }
        return false;
    }

    private final boolean checkString(String s) {
        String value = this.getCondition().getValue();
        FilterOp op = this.getCondition().getConditionType();
        switch (op) {
            case NULL: {
                return s == null;
            }
            case NOT_NULL: {
                return s != null;
            }
        }
        if (s == null) {
            return false;
        }
        int comp = s.compareTo(value);
        switch (op) {
            case EQUALS: {
                return comp == 0;
            }
            case NOT_EQUALS: {
                return comp != 0;
            }
            case GREATER: {
                return comp > 0;
            }
            case GREATER_EQ: {
                return comp >= 0;
            }
            case LESS: {
                return comp < 0;
            }
            case LESS_EQ: {
                return comp <= 0;
            }
        }
        return false;
    }

    private final boolean checkBoolean(boolean b) {
        String value = this.getCondition().getValue();
        boolean v = Boolean.parseBoolean(value);
        switch (this.getCondition().getConditionType()) {
            case EQUALS: {
                return v == b;
            }
            case NOT_EQUALS: {
                return v != b;
            }
        }
        return false;
    }

    private static final Stack<String> list2Stack(List<String> list) {
        Stack<String> stack = new Stack<String>();
        for (int i = list.size() - 1; i >= 0; --i) {
            stack.push(list.get(i));
        }
        return stack;
    }
}

