/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.dict_annot.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.annotator.dict_annot.dictionary.Dictionary;
import org.apache.uima.annotator.dict_annot.dictionary.DictionaryMatch;
import org.apache.uima.annotator.dict_annot.dictionary.impl.DictionaryFileParserImpl;
import org.apache.uima.annotator.dict_annot.dictionary.impl.HashMapDictionaryBuilder;
import org.apache.uima.annotator.dict_annot.impl.Condition;
import org.apache.uima.annotator.dict_annot.impl.DictionaryAnnotatorConfigException;
import org.apache.uima.annotator.dict_annot.impl.DictionaryAnnotatorProcessException;
import org.apache.uima.annotator.dict_annot.impl.FeaturePathInfo_impl;
import org.apache.uima.annotator.dict_annot.impl.FilterOp;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryAnnotator
extends CasAnnotator_ImplBase {
    public static final String MESSAGE_DIGEST = "org.apache.uima.annotator.dict_annot.dictionaryAnnotatorMessages";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String DICTIONARY_FILES = "DictionaryFiles";
    private static final String INPUT_MATCH_TYPE = "InputMatchType";
    private static final String INPUT_MATCH_FEATURE_PATH = "InputMatchFeaturePath";
    private static final String INPUT_MATCH_FILTER_FEATURE_PATH = "InputMatchFilterFeaturePath";
    private static final String FILTER_CONDITION_OPERATOR = "FilterConditionOperator";
    private static final String FILTER_CONDITION_VALUE = "FilterConditionValue";
    private Logger logger;
    private String inputMatchTypeStr;
    private String inputMatchFeaturePathStr;
    private String inputMatchFilterFeaturePathStr;
    private String filterConditionOperator;
    private String filterConditionValue;
    private Type inputMatchType;
    private Dictionary[] dictionaries;
    private FeaturePathInfo_impl inputMatchFeaturePath;
    private FeaturePathInfo_impl inputMatchFilterFeaturePath;
    private Condition filterCondition;

    public void process(CAS cas) throws AnalysisEngineProcessException {
        FSIterator it = cas.getAnnotationIndex(this.inputMatchType).iterator();
        ArrayList<AnnotationFS> inputTypeAnnots = new ArrayList<AnnotationFS>();
        while (it.hasNext()) {
            AnnotationFS annotFS = (AnnotationFS)it.next();
            if (this.inputMatchFilterFeaturePathStr != null) {
                if (!this.inputMatchFilterFeaturePath.match(annotFS, this.filterCondition)) continue;
                inputTypeAnnots.add(annotFS);
                continue;
            }
            inputTypeAnnots.add(annotFS);
        }
        AnnotationFS[] annotFSs = inputTypeAnnots.toArray(new AnnotationFS[0]);
        for (int i = 0; i < this.dictionaries.length; ++i) {
            Type currentDictOutputType = cas.getTypeSystem().getType(this.dictionaries[i].getTypeName());
            if (currentDictOutputType == null) {
                throw new DictionaryAnnotatorProcessException("dictionary_annotator_error_resolving_types", new Object[]{this.dictionaries[i].getTypeName()});
            }
            int currentPos = 0;
            while (currentPos < annotFSs.length) {
                DictionaryMatch dictMatch = this.dictionaries[i].matchEntry(currentPos, annotFSs, this.inputMatchFeaturePath);
                if (dictMatch != null) {
                    int matchLength = dictMatch.getMatchLength();
                    int start = annotFSs[currentPos].getBegin();
                    int end = annotFSs[currentPos + matchLength - 1].getEnd();
                    AnnotationFS fs = cas.createAnnotation(currentDictOutputType, start, end);
                    cas.getIndexRepository().addFS((FeatureStructure)fs);
                    currentPos += matchLength;
                    continue;
                }
                ++currentPos;
            }
        }
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.logger = this.getContext().getLogger();
        String[] dictionaryFileNames = DictionaryAnnotator.safeGetConfigParameterStringArrayValue(this.getContext(), DICTIONARY_FILES, new String[0]);
        this.inputMatchTypeStr = (String)this.getContext().getConfigParameterValue(INPUT_MATCH_TYPE);
        this.inputMatchFeaturePathStr = (String)this.getContext().getConfigParameterValue(INPUT_MATCH_FEATURE_PATH);
        this.inputMatchFeaturePath = new FeaturePathInfo_impl();
        if (this.inputMatchFeaturePathStr != null) {
            this.inputMatchFeaturePath.initialize(this.inputMatchFeaturePathStr);
        }
        this.inputMatchFilterFeaturePathStr = (String)this.getContext().getConfigParameterValue(INPUT_MATCH_FILTER_FEATURE_PATH);
        this.inputMatchFilterFeaturePath = new FeaturePathInfo_impl();
        if (this.inputMatchFilterFeaturePathStr != null) {
            this.inputMatchFilterFeaturePath.initialize(this.inputMatchFilterFeaturePathStr);
        }
        this.filterConditionOperator = (String)this.getContext().getConfigParameterValue(FILTER_CONDITION_OPERATOR);
        this.filterConditionValue = (String)this.getContext().getConfigParameterValue(FILTER_CONDITION_VALUE);
        if (this.inputMatchFilterFeaturePathStr != null) {
            if (this.filterConditionOperator == null) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_missing_config_parameter", new Object[]{FILTER_CONDITION_OPERATOR});
            }
            if (this.filterConditionValue == null) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_missing_config_parameter", new Object[]{FILTER_CONDITION_VALUE});
            }
            FilterOp operator = Condition.getOperator(this.filterConditionOperator);
            if (operator == null) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_condition_operator_not_valid", new Object[]{this.filterConditionOperator});
            }
            this.filterCondition = new Condition(operator, this.filterConditionValue);
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.inputMatchTypeStr);
            buffer.append(":");
            buffer.append(this.inputMatchFilterFeaturePathStr);
            buffer.append(" ");
            buffer.append(operator.toString());
            buffer.append(" ");
            buffer.append(this.filterConditionValue);
            this.logger.logrb(Level.CONFIG, "DictionaryAnnotator", "initialize", MESSAGE_DIGEST, "dictionary_annotator_filter_feature_condition", new Object[]{buffer.toString()});
        }
        DictionaryFileParserImpl fileParser = new DictionaryFileParserImpl();
        StringTokenizer tokenizer = new StringTokenizer(this.getContext().getDataPath(), PATH_SEPARATOR);
        ArrayList<File> datapathElements = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            datapathElements.add(new File(tokenizer.nextToken()));
        }
        ArrayList<Dictionary> dicts = new ArrayList<Dictionary>();
        for (int i = 0; i < dictionaryFileNames.length; ++i) {
            DictionaryFile file = this.resolveRelativeFilePath(dictionaryFileNames[i], datapathElements);
            if (file == null) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_resource_not_found", new Object[]{dictionaryFileNames[i]});
            }
            this.logger.logrb(Level.CONFIG, "DictionaryAnnotator", "initialize", MESSAGE_DIGEST, "dictionary_annotator_dictionary_file", new Object[]{file.getFilePath()});
            Dictionary dict = fileParser.parseDictionaryFile(file.getFilePath(), file.getStream(), new HashMapDictionaryBuilder());
            dicts.add(dict);
        }
        this.dictionaries = dicts.toArray(new Dictionary[0]);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.inputMatchType = typeSystem.getType(this.inputMatchTypeStr);
        if (this.inputMatchType == null) {
            throw new DictionaryAnnotatorProcessException("dictionary_annotator_error_resolving_types", new Object[]{this.inputMatchTypeStr});
        }
        if (this.inputMatchFeaturePathStr != null) {
            this.inputMatchFeaturePath.typeSystemInit(this.inputMatchType);
        }
        if (this.inputMatchFilterFeaturePathStr != null) {
            this.inputMatchFilterFeaturePath.typeSystemInit(this.inputMatchType);
        }
    }

    private static String[] safeGetConfigParameterStringArrayValue(UimaContext context, String param, String[] defaultValue) {
        String[] array = (String[])context.getConfigParameterValue(param);
        if (array != null && array.length > 0) {
            return array;
        }
        return defaultValue;
    }

    private DictionaryFile resolveRelativeFilePath(String fileName, ArrayList<File> datapathElements) throws DictionaryAnnotatorConfigException {
        URL url = null;
        if (fileName.startsWith("http")) {
            try {
                url = new URL(fileName);
                URLConnection connection = url.openConnection();
                DictionaryFile dictionaryFile = new DictionaryFile(url.toString(), new BufferedInputStream(connection.getInputStream()));
                return dictionaryFile;
            }
            catch (MalformedURLException ex) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_invalid_url_resource", new Object[]{fileName}, ex);
            }
            catch (IOException ex) {
                throw new DictionaryAnnotatorConfigException("dictionary_annotator_invalid_url_resource", new Object[]{fileName}, ex);
            }
        }
        url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName);
        if (url != null) {
            InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            DictionaryFile dictionaryFile = new DictionaryFile(url.getFile(), new BufferedInputStream(stream));
            return dictionaryFile;
        }
        if (datapathElements == null || datapathElements.size() == 0) {
            return null;
        }
        for (int i = 0; i < datapathElements.size(); ++i) {
            BufferedInputStream stream;
            File testFile = new File(datapathElements.get(i), fileName);
            if (!testFile.exists()) continue;
            try {
                stream = new BufferedInputStream(new FileInputStream(testFile));
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            DictionaryFile dictionaryFile = new DictionaryFile(testFile.getAbsolutePath(), stream);
            return dictionaryFile;
        }
        return null;
    }

    private static class DictionaryFile {
        private String filePath;
        private InputStream stream;

        public DictionaryFile(String filePath, InputStream stream) {
            this.filePath = filePath;
            this.stream = stream;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public InputStream getStream() {
            return this.stream;
        }
    }
}

