/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.annotator.regex.Feature;
import org.apache.uima.annotator.regex.FeaturePath;
import org.apache.uima.annotator.regex.FilterFeature;
import org.apache.uima.annotator.regex.RegexVariables;
import org.apache.uima.annotator.regex.Rule;
import org.apache.uima.annotator.regex.RuleException;
import org.apache.uima.annotator.regex.impl.FeaturePath_impl;
import org.apache.uima.annotator.regex.impl.Feature_impl;
import org.apache.uima.annotator.regex.impl.FilterFeature_impl;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.annotator.regex.impl.RuleException_impl;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;

public class Rule_impl
implements Rule {
    private String regex;
    private final String id;
    private final float confidence;
    private final String matchTypeStr;
    private FeaturePath_impl featurePath;
    private boolean isFeaturePathMatch = false;
    private final int matchStrategy;
    private Pattern pattern;
    private Type matchType;
    private ArrayList<FilterFeature> filterFeatures;
    private ArrayList<Feature> updateFeatures;
    private ArrayList<RuleException> exceptions;
    private RegexVariables variables;
    private HashMap<String, Integer> matchGroupNames;

    public Rule_impl(String regex, int matchStrategy, String matchType, String id, float confidence, String featurePath, RegexVariables variables) {
        this.regex = regex;
        this.matchStrategy = matchStrategy;
        this.matchTypeStr = matchType;
        this.filterFeatures = new ArrayList();
        this.updateFeatures = new ArrayList();
        this.exceptions = new ArrayList();
        this.pattern = null;
        this.id = id;
        this.confidence = confidence;
        this.featurePath = new FeaturePath_impl(featurePath);
        if (featurePath != null) {
            this.isFeaturePathMatch = true;
        }
        this.variables = variables;
        this.matchGroupNames = new HashMap();
    }

    public void addFilterFeature(FilterFeature aFeature) {
        this.filterFeatures.add(aFeature);
    }

    public FilterFeature[] getMatchTypeFilterFeatures() {
        return this.filterFeatures.toArray(new FilterFeature[0]);
    }

    public int getMatchStrategy() {
        return this.matchStrategy;
    }

    public Type getMatchType() {
        return this.matchType;
    }

    public Pattern getRegexPattern() {
        return this.pattern;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public String getId() {
        return this.id;
    }

    public void addUpdateFeature(Feature aFeature) {
        this.updateFeatures.add(aFeature);
    }

    public Feature[] getMatchTypeUpdateFeatures() {
        return this.updateFeatures.toArray(new Feature[0]);
    }

    public void addException(RuleException aException) {
        this.exceptions.add(aException);
    }

    public RuleException[] getExceptions() {
        return this.exceptions.toArray(new RuleException[0]);
    }

    public FeaturePath getMatchTypeFeaturePath() {
        return this.featurePath;
    }

    public boolean isFeaturePathMatch() {
        return this.isFeaturePathMatch;
    }

    public void typeInit(TypeSystem ts) throws ResourceInitializationException {
        if (this.matchTypeStr != null) {
            this.matchType = ts.getType(this.matchTypeStr);
            if (this.matchType == null) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_resolving_types", new Object[]{this.matchTypeStr});
            }
        }
        FilterFeature[] filterFeats = this.getMatchTypeFilterFeatures();
        for (int i = 0; i < filterFeats.length; ++i) {
            ((FilterFeature_impl)filterFeats[i]).typeInit(this.matchType);
        }
        Feature[] updateFeats = this.getMatchTypeUpdateFeatures();
        for (int i = 0; i < updateFeats.length; ++i) {
            ((Feature_impl)updateFeats[i]).typeInit(this.matchType);
        }
        RuleException[] ruleExceptions = this.getExceptions();
        for (int i = 0; i < ruleExceptions.length; ++i) {
            ((RuleException_impl)ruleExceptions[i]).typeInit(ts);
        }
        this.featurePath.initialize(this.matchType);
    }

    public void initialize() throws RegexAnnotatorConfigException {
        if (this.regex.indexOf("\\v") > -1) {
            this.replaceRegexVariables();
        }
        if (this.regex.indexOf("\\m") > -1) {
            this.evaluateMatchGroupNames();
        }
        this.pattern = Pattern.compile(this.regex);
        FilterFeature[] filterFeats = this.getMatchTypeFilterFeatures();
        for (int i = 0; i < filterFeats.length; ++i) {
            ((FilterFeature_impl)filterFeats[i]).initialize();
        }
        Feature[] updateFeats = this.getMatchTypeUpdateFeatures();
        for (int i = 0; i < updateFeats.length; ++i) {
            ((Feature_impl)updateFeats[i]).initialize();
        }
        RuleException[] ruleExceptions = this.getExceptions();
        for (int i = 0; i < ruleExceptions.length; ++i) {
            ((RuleException_impl)ruleExceptions[i]).initialize();
        }
    }

    public int getMatchGroupNumber(String matchGroupName) {
        Integer value = this.matchGroupNames.get(matchGroupName.toLowerCase());
        if (value != null) {
            return value;
        }
        return -1;
    }

    private void replaceRegexVariables() throws RegexAnnotatorConfigException {
        Matcher matcher = RegexVariables.VARIABLE_REGEX_PATTERN.matcher(this.regex);
        int pos = 0;
        HashSet<String> variableSet = new HashSet<String>();
        while (matcher.find(pos)) {
            int varStart = matcher.start(1);
            int varEnd = matcher.end(1);
            variableSet.add(this.regex.substring(varStart, varEnd));
            pos = matcher.end();
        }
        for (String variableName : variableSet) {
            if (this.variables == null) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_variable_not_found", new Object[]{variableName, this.id});
            }
            String varValue = this.variables.getVariableValue(variableName);
            if (varValue != null) {
                String variablePattern = "\\\\v\\{" + variableName + "\\}";
                this.regex = this.regex.replaceAll(variablePattern, varValue);
                continue;
            }
            throw new RegexAnnotatorConfigException("regex_annotator_error_variable_not_found", new Object[]{variableName, this.id});
        }
    }

    private void evaluateMatchGroupNames() {
        Matcher matcher = Rule.MATCH_GROUP_REGEX_PATTERN.matcher(this.regex);
        ArrayList<String> names = new ArrayList<String>();
        int pos = 0;
        while (matcher.find(pos)) {
            int varStart = matcher.start(1);
            int varEnd = matcher.end(1);
            int groupCounter = 1;
            for (int i = 0; i < varEnd; ++i) {
                if (this.regex.charAt(i) != '(' || this.regex.charAt(i + 1) == '?') continue;
                ++groupCounter;
            }
            String matchGroupName = this.regex.substring(varStart, varEnd);
            this.matchGroupNames.put(matchGroupName.toLowerCase(), groupCounter);
            names.add(matchGroupName);
            pos = matcher.end();
        }
        for (String matchGroupName : names) {
            String matchGroupNamePattern = "\\\\m\\{" + matchGroupName + "\\}";
            this.regex = this.regex.replaceAll(matchGroupNamePattern, "");
        }
    }

    public String toString() {
        FilterFeature[] filterFeats;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Rule ");
        if (this.id != null) {
            buffer.append(this.id);
        }
        buffer.append("\n");
        buffer.append("Regex: ");
        buffer.append(this.regex);
        if (this.matchStrategy == 2) {
            buffer.append("\nMatch strategy: MATCH_ALL");
        } else if (this.matchStrategy == 3) {
            buffer.append("\nMatch strategy: MATCH_COMPLETE");
        } else if (this.matchStrategy == 1) {
            buffer.append("\nMatch strategy: MATCH_FIRST");
        }
        buffer.append("\nMatch type: ");
        buffer.append(this.matchTypeStr);
        buffer.append("\nFeaturePath: ");
        buffer.append(this.featurePath.getFeaturePath());
        if ((double)this.confidence != 0.0) {
            buffer.append("\nConfidence: ");
            buffer.append(this.confidence);
        }
        if ((filterFeats = this.getMatchTypeFilterFeatures()).length > 0) {
            buffer.append("\nMatch type filter features: \n");
        }
        for (int i = 0; i < filterFeats.length; ++i) {
            buffer.append(filterFeats[i].toString());
        }
        buffer.append("\n");
        RuleException[] ruleExceptions = this.getExceptions();
        if (ruleExceptions.length > 0) {
            buffer.append("\nRule exceptions: \n");
        }
        for (int i = 0; i < ruleExceptions.length; ++i) {
            buffer.append(ruleExceptions[i].toString());
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

