/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenStreamMerger
extends TokenStream {
    private Collection<TokenStream> streams;
    private int currentOffset;
    private TokenStreamComparator comparator;
    private Stack<TokenStream> sortedStreams;
    private boolean initialized;
    private PositionIncrementAttribute posIncAtt;

    public TokenStreamMerger(Collection<TokenStream> streams) throws IOException {
        this.streams = streams;
        this.comparator = new TokenStreamComparator();
        this.currentOffset = -1;
        this.sortedStreams = new Stack();
        for (TokenStream stream : streams) {
            Iterator attIt = stream.getAttributeClassesIterator();
            while (attIt.hasNext()) {
                Class attClass = (Class)attIt.next();
                this.addAttribute(attClass);
            }
        }
        this.posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    private void init() throws IOException {
        for (TokenStream stream : this.streams) {
            stream.reset();
            stream.incrementToken();
            this.sortedStreams.add(stream);
        }
        this.rebuildSortedTokens();
        this.initialized = true;
    }

    public void reset() throws IOException {
        for (TokenStream stream : this.streams) {
            stream.reset();
        }
        this.currentOffset = -1;
        this.sortedStreams.clear();
        this.initialized = false;
    }

    public boolean incrementToken() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        if (this.sortedStreams.size() == 0) {
            return false;
        }
        TokenStream currentTokenStream = this.sortedStreams.pop();
        this.restoreState(currentTokenStream.captureState());
        OffsetAttribute offsetAttr = (OffsetAttribute)currentTokenStream.getAttribute(OffsetAttribute.class);
        if (offsetAttr.startOffset() == this.currentOffset) {
            this.posIncAtt.setPositionIncrement(0);
        } else {
            this.posIncAtt.setPositionIncrement(1);
        }
        this.currentOffset = offsetAttr.startOffset();
        if (currentTokenStream.incrementToken()) {
            this.sortedStreams.add(currentTokenStream);
        }
        this.rebuildSortedTokens();
        return true;
    }

    private void rebuildSortedTokens() throws IOException {
        Collections.sort(this.sortedStreams, this.comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TokenStreamComparator
    implements Comparator<TokenStream> {
        private TokenStreamComparator() {
        }

        @Override
        public int compare(TokenStream stream1, TokenStream stream2) {
            OffsetAttribute attr1 = (OffsetAttribute)stream1.getAttribute(OffsetAttribute.class);
            OffsetAttribute attr2 = (OffsetAttribute)stream2.getAttribute(OffsetAttribute.class);
            return attr2.startOffset() - attr1.startOffset();
        }
    }
}

