/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.util.PlainFileReaderFactory;

public class StopwordFilterFactory
implements TokenFilterFactory {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String FILE_PATH_PARAMETER = "filePath";
    public static final String IGRNORE_CASE_PARAMETER = "ignoreCase";
    private PlainFileReaderFactory plainFileReaderFactory;
    private Map<String, String[]> cachedStopwords;
    private static Logger LOGGER = Logger.getLogger(StopwordFilterFactory.class);

    public StopwordFilterFactory(PlainFileReaderFactory plainFileReaderFactory) {
        this.plainFileReaderFactory = plainFileReaderFactory;
        this.cachedStopwords = new HashMap<String, String[]>();
    }

    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        String ignoreCase = properties.getProperty(IGRNORE_CASE_PARAMETER);
        ignoreCase = ignoreCase == null ? FALSE : ignoreCase;
        String[] stopwords = this.getStopwords(filePath);
        return new StopFilter(tokenStream, stopwords, ignoreCase.equals(TRUE));
    }

    private String[] getStopwords(String filePath) throws IOException {
        String[] stopwords = this.cachedStopwords.get(filePath);
        if (stopwords == null) {
            stopwords = this.plainFileReaderFactory.createPlainFileReader(filePath).readLines();
            LOGGER.info((Object)("file " + filePath + " loaded with " + stopwords.length + " stopwords"));
            this.cachedStopwords.put(filePath, stopwords);
        }
        return stopwords;
    }

    public void preloadResources(Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        String[] stopwords = this.getStopwords(filePath);
    }
}

