/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class PositionFilter
extends TokenFilter {
    public static final Integer FIRST_POSITION = 0;
    public static final Integer LAST_POSITION = 1;
    private TokenStream input;
    private Token token;
    private Integer position;

    public PositionFilter(TokenStream input, Integer position) {
        super(input);
        this.input = input;
        this.position = position;
    }

    public Token next(Token nextToken) throws IOException {
        Token newToken = this.input.next(nextToken);
        if (this.position.equals(FIRST_POSITION)) {
            if (this.token != null) {
                return null;
            }
            this.token = newToken;
            return newToken;
        }
        if (this.position.equals(LAST_POSITION)) {
            Token lastToken = null;
            while (newToken != null) {
                lastToken = newToken;
                newToken = this.input.next(nextToken);
            }
            return lastToken;
        }
        return newToken;
    }

    public Integer getPosition() {
        return this.position;
    }
}

