/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.analysis.HypernymFilter;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.util.MultimapFileReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypernymFilterFactory
implements TokenFilterFactory {
    public static final String FILE_PATH_PARAMETER = "filePath";
    private Map<String, Map<String, List<String>>> cachedMappings;
    private MultimapFileReaderFactory multimapFileReaderFactory;
    private static Logger LOGGER = Logger.getLogger(HypernymFilterFactory.class);

    public HypernymFilterFactory(MultimapFileReaderFactory multimapFileReaderFactory) {
        this.multimapFileReaderFactory = multimapFileReaderFactory;
        this.cachedMappings = new HashMap<String, Map<String, List<String>>>();
    }

    @Override
    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        Map<String, List<String>> hypernyms = this.getHypernyms(filePath);
        return new HypernymFilter(tokenStream, hypernyms);
    }

    private Map<String, List<String>> getHypernyms(String filePath) throws IOException {
        Map<String, List<String>> hypernyms = this.cachedMappings.get(filePath);
        if (hypernyms == null) {
            hypernyms = this.multimapFileReaderFactory.createMultimapFileReader(filePath).readMultimap();
            LOGGER.info((Object)("file " + filePath + " loaded with " + hypernyms.size()));
            this.cachedMappings.put(filePath, hypernyms);
        }
        return hypernyms;
    }

    @Override
    public void preloadResources(Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        Map<String, List<String>> hypernyms = this.getHypernyms(filePath);
    }

    public Map<String, Map<String, List<String>>> getCachedMappings() {
        return this.cachedMappings;
    }
}

