/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.uima.lucas.indexer.FieldBuildingException;
import org.apache.uima.lucas.indexer.FilterBuilder;
import org.apache.uima.lucas.indexer.FilterBuildingException;
import org.apache.uima.lucas.indexer.analysis.TokenStreamConcatenator;
import org.apache.uima.lucas.indexer.analysis.TokenStreamMerger;
import org.apache.uima.lucas.indexer.mapping.FieldDescription;
import org.apache.uima.lucas.indexer.mapping.FilterDescription;
import org.apache.uima.lucas.indexer.util.TokenStreamStringConcatenator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBuilder {
    public static final String FIELD_INDEX_NO = "no";
    public static final String FIELD_INDEX_YES = "yes";
    public static final String FIELD_INDEX_NO_NORMS = "no_norms";
    public static final String FIELD_INDEX_NO_TF = "no_tf";
    public static final String FIELD_INDEX_NO_NORMS_TF = "no_norms_tf";
    public static final String FIELD_TERM_VECTOR_NO = "no";
    public static final String FIELD_TERM_VECTOR_YES = "yes";
    public static final String FIELD_TERM_VECTOR_WITH_OFFSETS = "offsets";
    public static final String FIELD_TERM_VECTOR_WITH_POSITIONS = "positions";
    public static final String FIELD_TERM_VECTOR_WITH_POSITIONS_OFFSETS = "positions_offsets";
    public static final String FIELD_STORE_NO = "no";
    public static final String FIELD_STORE_YES = "yes";
    public static final String FIELD_STORE_COMPRESS = "compress";
    protected TokenStreamStringConcatenator tokenStreamStringConcatenator = new TokenStreamStringConcatenator();
    private FilterBuilder filterBuilder;
    protected FieldDescription fieldDescription;

    public FieldBuilder(FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
    }

    public Collection<Field> createFields(Collection<TokenStream> tokenStreams, FieldDescription fieldDescription) throws FieldBuildingException {
        boolean store;
        TokenStream tokenStream = this.createFieldTokenStream(tokenStreams, fieldDescription);
        this.fieldDescription = fieldDescription;
        String fieldName = fieldDescription.getName();
        String delimiter = fieldDescription.getDelimiter();
        ArrayList<Field> fields = new ArrayList<Field>();
        Collection<FilterDescription> filterDescriptions = fieldDescription.getFilterDescriptions();
        tokenStream = this.getFilteredTokenStream(fieldName, tokenStream, filterDescriptions);
        Boolean unique = fieldDescription.getUnique();
        Field.Store fieldStore = this.getFieldStore(fieldDescription.getStored());
        Field.Index fieldIndex = this.getFieldIndex(fieldDescription.getIndex());
        Field.TermVector fieldTermVector = this.getFieldTermVector(fieldDescription.getTermVector());
        boolean omitTF = fieldDescription.getIndex().equals(FIELD_INDEX_NO_TF) || fieldDescription.getIndex().equals(FIELD_INDEX_NO_NORMS_TF);
        boolean bl = store = fieldStore == Field.Store.YES || fieldStore == Field.Store.COMPRESS;
        if (store) {
            fields.addAll(this.createStoredFields(fieldName, tokenStream, fieldStore, delimiter, unique, fieldIndex, omitTF));
        }
        if (!(fieldIndex == Field.Index.NO || unique.booleanValue() && store)) {
            fields.add(this.createIndexedField(fieldName, tokenStream, fieldIndex, fieldTermVector, omitTF));
        }
        return fields;
    }

    protected TokenStream createFieldTokenStream(Collection<TokenStream> tokenStreams, FieldDescription fieldDescription) throws FieldBuildingException {
        TokenStream tokenStream = null;
        if (fieldDescription.getMerge().booleanValue()) {
            tokenStream = this.getTokenStreamMerger(tokenStreams);
        } else if (tokenStreams.size() > 1) {
            tokenStream = new TokenStreamConcatenator(tokenStreams);
        } else if (tokenStreams.size() == 1) {
            tokenStream = tokenStreams.iterator().next();
        }
        return tokenStream;
    }

    protected TokenStream getFilteredTokenStream(String fieldName, TokenStream tokenStream, Collection<FilterDescription> filterDescriptions) throws FieldBuildingException {
        try {
            return this.filterBuilder.filter(tokenStream, filterDescriptions);
        }
        catch (FilterBuildingException e) {
            throw this.createException(e);
        }
    }

    protected FieldBuildingException createException(Exception e) {
        String message = "Can't build field " + this.fieldDescription.getName() + " at line " + this.fieldDescription.getLineNumber();
        return new FieldBuildingException(message, e);
    }

    private TokenStream getTokenStreamMerger(Collection<TokenStream> tokenStreams) throws FieldBuildingException {
        try {
            return new TokenStreamMerger(tokenStreams);
        }
        catch (IOException e) {
            throw this.createException(e);
        }
    }

    protected Field createIndexedField(String fieldName, TokenStream tokenStream, Field.Index fieldIndex, Field.TermVector fieldTermVector, boolean omitTF) {
        Field field = new Field(fieldName, tokenStream, fieldTermVector);
        if (fieldIndex == Field.Index.NOT_ANALYZED_NO_NORMS) {
            field.setOmitNorms(true);
        }
        field.setOmitTermFreqAndPositions(omitTF);
        return field;
    }

    protected Collection<Field> createStoredFields(String fieldName, TokenStream tokenStream, Field.Store fieldStore, String delimiter, Boolean unique, Field.Index fieldIndex, Boolean omitTF) throws FieldBuildingException {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field.Index index = unique != false ? fieldIndex : Field.Index.NO;
        try {
            if (delimiter != null) {
                String value = this.tokenStreamStringConcatenator.tokenStreamToStringWithDelimiter(tokenStream, delimiter);
                Field field = new Field(fieldName, value, fieldStore, index);
                if (unique.booleanValue()) {
                    field.setOmitTermFreqAndPositions(omitTF.booleanValue());
                }
                fields.add(field);
            } else {
                Token nextToken = tokenStream.next(new Token());
                while (nextToken != null) {
                    String value = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                    Field field = new Field(fieldName, value, fieldStore, index);
                    if (unique.booleanValue()) {
                        field.setOmitTermFreqAndPositions(omitTF.booleanValue());
                    }
                    fields.add(field);
                    nextToken = tokenStream.next(nextToken);
                }
            }
            tokenStream.reset();
        }
        catch (IOException e) {
            throw this.createException(e);
        }
        return fields;
    }

    protected Field.Index getFieldIndex(String index) throws FieldBuildingException {
        if (index.equals("no")) {
            return Field.Index.NO;
        }
        if (index.equals("yes")) {
            return Field.Index.NOT_ANALYZED;
        }
        if (index.equals(FIELD_INDEX_NO_NORMS)) {
            return Field.Index.NOT_ANALYZED_NO_NORMS;
        }
        if (index.equals(FIELD_INDEX_NO_NORMS_TF)) {
            return Field.Index.NOT_ANALYZED_NO_NORMS;
        }
        if (index.equals(FIELD_INDEX_NO_TF)) {
            return Field.Index.NOT_ANALYZED;
        }
        throw this.createException(new IllegalArgumentException("unknown index parameter: " + index));
    }

    protected Field.TermVector getFieldTermVector(String termVector) throws FieldBuildingException {
        if (termVector.equals("no")) {
            return Field.TermVector.NO;
        }
        if (termVector.equals("yes")) {
            return Field.TermVector.YES;
        }
        if (termVector.equals(FIELD_TERM_VECTOR_WITH_OFFSETS)) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if (termVector.equals(FIELD_TERM_VECTOR_WITH_POSITIONS)) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if (termVector.equals(FIELD_TERM_VECTOR_WITH_POSITIONS_OFFSETS)) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        throw this.createException(new IllegalArgumentException("unknown termVector parameter: " + termVector));
    }

    protected Field.Store getFieldStore(String store) throws FieldBuildingException {
        if (store.equals("no")) {
            return Field.Store.NO;
        }
        if (store.equals("yes")) {
            return Field.Store.YES;
        }
        if (store.equals(FIELD_STORE_COMPRESS)) {
            return Field.Store.COMPRESS;
        }
        throw this.createException(new IllegalArgumentException("unknown stored parameter: " + store));
    }
}

