/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.uima.jcas.JCas;
import org.apache.uima.lucas.indexer.AnnotationTokenStreamBuildingException;
import org.apache.uima.lucas.indexer.analysis.AnnotationTokenStream;
import org.apache.uima.lucas.indexer.analysis.InvalidTokenSourceException;
import org.apache.uima.lucas.indexer.mapping.AnnotationDescription;
import org.apache.uima.lucas.indexer.mapping.FeatureDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTokenStreamBuilder {
    private static final Logger LOGGER = Logger.getLogger(AnnotationTokenStreamBuilder.class);

    public AnnotationTokenStream createAnnotationTokenStream(JCas jCas, AnnotationDescription annotationDescription) throws AnnotationTokenStreamBuildingException {
        String sofaName = annotationDescription.getSofa();
        sofaName = sofaName == null ? "_InitialView" : sofaName;
        AnnotationTokenStream annotationTokenStream = null;
        String typeName = annotationDescription.getType();
        if (annotationDescription.getFeatureDescriptions().size() == 0) {
            try {
                annotationTokenStream = new AnnotationTokenStream(jCas, sofaName, typeName);
            }
            catch (InvalidTokenSourceException e) {
                throw this.createException(annotationDescription, e);
            }
        }
        String featurePath = annotationDescription.getFeaturePath();
        String delimiter = annotationDescription.getFeatureValueDelimiterString();
        Collection<FeatureDescription> featureDescriptions = annotationDescription.getFeatureDescriptions();
        List<String> featureNames = this.extractFeatureNames(featureDescriptions);
        Map<String, Format> featureFormats = this.extractFeatureFormats(featureDescriptions);
        if (featurePath != null) {
            try {
                annotationTokenStream = new AnnotationTokenStream(jCas, sofaName, typeName, featurePath, featureNames, delimiter, featureFormats);
            }
            catch (InvalidTokenSourceException e) {
                throw this.createException(annotationDescription, e);
            }
        }
        try {
            annotationTokenStream = new AnnotationTokenStream(jCas, sofaName, typeName, featureNames, delimiter, featureFormats);
        }
        catch (InvalidTokenSourceException e) {
            throw this.createException(annotationDescription, e);
        }
        return annotationTokenStream;
    }

    private List<String> extractFeatureNames(Collection<FeatureDescription> featureDescriptions) {
        ArrayList<String> featureNames = new ArrayList<String>();
        for (FeatureDescription featureDescription : featureDescriptions) {
            featureNames.add(featureDescription.getFeatureName());
        }
        return featureNames;
    }

    private Map<String, Format> extractFeatureFormats(Collection<FeatureDescription> featureDescriptions) {
        HashMap<String, Format> featureFormats = new HashMap<String, Format>();
        for (FeatureDescription featureDescription : featureDescriptions) {
            if (featureDescription.getNumberFormat() == null) continue;
            DecimalFormat format = new DecimalFormat(featureDescription.getNumberFormat());
            featureFormats.put(featureDescription.getFeatureName(), format);
        }
        return featureFormats;
    }

    private AnnotationTokenStreamBuildingException createException(AnnotationDescription annotationDescription, InvalidTokenSourceException e) {
        String message = "Can't build TokenStream from annotation at line " + annotationDescription.getLineNumber();
        return new AnnotationTokenStreamBuildingException(message, e);
    }
}

