/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.consumer;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.lucas.LuceneDocumentAE;
import org.apache.uima.lucas.indexer.IndexWriterProvider;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public class LuceneCASIndexer
extends LuceneDocumentAE {
    private static final String RESOURCE_INDEX_WRITER_PROVIDER = "indexWriterProvider";
    private static final Logger logger = Logger.getLogger(LuceneCASIndexer.class);
    protected IndexWriter indexWriter;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.getIndexWriterInstance();
    }

    private void getIndexWriterInstance() throws ResourceInitializationException {
        IndexWriterProvider indexWriterProvider;
        UimaContext uimaContext = this.getContext();
        try {
            indexWriterProvider = (IndexWriterProvider)uimaContext.getResourceObject(RESOURCE_INDEX_WRITER_PROVIDER);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.indexWriter = indexWriterProvider.getIndexWriter();
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        try {
            this.indexWriter.addDocument(this.createDocument(cas));
        }
        catch (IOException e) {
            logger.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void destroy() {
        logger.info((Object)("destroy " + LuceneCASIndexer.class));
        this.optimizeIndex();
        super.destroy();
    }

    public void optimizeIndex() {
        try {
            logger.info((Object)"optimizing the index now!");
            this.indexWriter.optimize();
            this.indexWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)"exception while closing index", (Throwable)e);
        }
    }
}

