/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.lucas.LuceneDocumentAE;
import org.apache.uima.lucas.SearchQuery;
import org.apache.uima.lucas.SearchQueryProvider;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public class ProspectiveSearchAE
extends LuceneDocumentAE {
    private SearchQueryProvider searchQueryProvider;
    private Type searchResultType;
    private Feature searchResultIdFeature;
    private Feature searchResultMatchingTextFeature;
    private Type matchingTextType;
    private float matchingThreshold = 0.0f;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.searchQueryProvider = (SearchQueryProvider)aContext.getResourceObject("searchQueryProvider");
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(aTypeSystem);
        String searchResultTypeString = (String)this.getContext().getConfigParameterValue("org.apache.uima.lucas.SearchResultType");
        this.searchResultType = aTypeSystem.getType(searchResultTypeString);
        String searchResultIdFeatureString = (String)this.getContext().getConfigParameterValue("org.apache.uima.lucas.SearchResultIdFeature");
        this.searchResultIdFeature = this.searchResultType.getFeatureByBaseName(searchResultIdFeatureString);
        String searchResultMatchingTextFeatureString = (String)this.getContext().getConfigParameterValue("org.apache.uima.lucas.SearchResulMatchingTextFeature");
        if (searchResultMatchingTextFeatureString != null) {
            this.searchResultMatchingTextFeature = this.searchResultType.getFeatureByBaseName(searchResultMatchingTextFeatureString);
            String matchingTextTypeString = (String)this.getContext().getConfigParameterValue("org.apache.uima.lucas.MatchingTextType");
            this.matchingTextType = matchingTextTypeString != null ? aTypeSystem.getType(matchingTextTypeString) : aTypeSystem.getType("uima.tcas.Annotation");
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        MemoryIndex index = new MemoryIndex();
        List fields = this.createDocument(aCAS).getFields();
        for (Field field : fields) {
            if (!field.isIndexed() || field.tokenStreamValue() == null) continue;
            index.addField(field.name(), field.tokenStreamValue());
        }
        for (SearchQuery query : this.searchQueryProvider.getSearchQueries(aCAS)) {
            float score = index.search(query.query());
            if (!(score > this.matchingThreshold)) continue;
            FeatureStructure searchResult = aCAS.createFS(this.searchResultType);
            searchResult.setLongValue(this.searchResultIdFeature, query.id());
            aCAS.addFsToIndexes(searchResult);
            if (this.searchResultMatchingTextFeature == null) continue;
            fields = this.createDocument(aCAS).getFields();
            for (Field field : fields) {
                if (!field.isIndexed() || field.tokenStreamValue() == null) continue;
                TokenStream tokenStream = field.tokenStreamValue();
                LinkedList<AnnotationFS> matchingTextAnnotations = new LinkedList<AnnotationFS>();
                QueryScorer scorer = new QueryScorer(query.query(), field.name());
                scorer.startFragment(new TextFragment(new StringBuffer(aCAS.getDocumentText()), 0, 0));
                try {
                    scorer.init(tokenStream);
                    OffsetAttribute offsetAttr = null;
                    while (tokenStream.incrementToken()) {
                        offsetAttr = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
                        float tokenScore = scorer.getTokenScore();
                        if (!(tokenScore > 0.0f)) continue;
                        AnnotationFS annotation = aCAS.createAnnotation(this.matchingTextType, offsetAttr.startOffset(), offsetAttr.endOffset());
                        matchingTextAnnotations.add(annotation);
                    }
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                ArrayFS matchtingTextArray = aCAS.createArrayFS(matchingTextAnnotations.size());
                int matchtingTextArrayIndex = 0;
                for (AnnotationFS matchingTextAnnotation : matchingTextAnnotations) {
                    matchtingTextArray.set(matchtingTextArrayIndex++, (FeatureStructure)matchingTextAnnotation);
                }
                searchResult.setFeatureValue(this.searchResultMatchingTextFeature, (FeatureStructure)matchtingTextArray);
            }
        }
    }
}

