/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.support.FeatureConstrainedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMAAnnotationUtils {
    public static int getTypeIndexId(Class<? extends Annotation> cls) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        return cls.getField("typeIndexID").getInt(null);
    }

    public static int getTypeIndexId(String typename) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        return UIMAAnnotationUtils.getTypeIndexId(UIMAAnnotationUtils.forName(typename));
    }

    public static int getTypeIndexId(Type type) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        return UIMAAnnotationUtils.getTypeIndexId(type.getName());
    }

    public static boolean containsAnnotationBySpan(Object[] annotations, Annotation test) {
        for (int i = 0; i < annotations.length; ++i) {
            Annotation co = (Annotation)annotations[i];
            if (co.getBegin() != test.getBegin() || co.getEnd() != test.getEnd()) continue;
            return true;
        }
        return false;
    }

    public static void addFSArrayToAnnotations(List<Annotation> dest, FSArray source) {
        for (int i = 0; i < source.size(); ++i) {
            dest.add((Annotation)source.get(i));
        }
    }

    public static List<Annotation> fsArrayToAnnotations(FSArray source) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        UIMAAnnotationUtils.addFSArrayToAnnotations(result, source);
        return result;
    }

    public static void addAnnotationsToFSArray(JCas jcas, Annotation parent, String feat_name, Collection<Annotation> anns, boolean update_span) {
        Feature feat = jcas.getCasType(parent.getTypeIndexID()).getFeatureByBaseName(feat_name);
        FSArray fsa = (FSArray)parent.getFeatureValue(feat);
        ArrayList<Annotation> new_elements = new ArrayList<Annotation>();
        if (null != fsa) {
            UIMAAnnotationUtils.addFSArrayToAnnotations(new_elements, fsa);
        }
        new_elements.addAll(anns);
        int b = Integer.MAX_VALUE;
        int e = Integer.MIN_VALUE;
        FSArray new_fsa = new FSArray(jcas, new_elements.size());
        for (int i = 0; i < new_elements.size(); ++i) {
            Annotation ann = (Annotation)new_elements.get(i);
            new_fsa.set(i, (FeatureStructure)ann);
            if (b > ann.getBegin()) {
                b = ann.getBegin();
            }
            if (e >= ann.getEnd()) continue;
            e = ann.getEnd();
        }
        parent.setFeatureValue(feat, (FeatureStructure)new_fsa);
        if (update_span) {
            parent.removeFromIndexes();
            UIMAAnnotationUtils.updateSpan(parent, b, e);
            parent.addToIndexes();
        }
    }

    public static void updateSpan(Annotation target, Annotation included) {
        UIMAAnnotationUtils.updateSpan(target, included.getBegin(), included.getEnd());
    }

    public static void updateSpan(Annotation target, int b, int e) {
        boolean force_offset = false;
        if (0 == target.getBegin() && 0 == target.getEnd()) {
            force_offset = true;
        }
        if (force_offset || target.getBegin() > b) {
            target.setBegin(b);
        }
        if (force_offset || target.getEnd() < e) {
            target.setEnd(e);
        }
    }

    public static boolean sameSpanAnnotations(Annotation ann1, Annotation ann2) {
        return ann1.getBegin() == ann2.getBegin() && ann1.getEnd() == ann2.getEnd();
    }

    public static Annotation getSameOffsetAnnotation(JCas jcas, Class<? extends Annotation> ann_class, int begin, int end) {
        try {
            FSIterator<? extends Annotation> it = FeatureConstrainedIterator.getEnclosedIterator(jcas, ann_class, begin, begin + 1, end - 1, end);
            if (it.hasNext()) {
                return (Annotation)it.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Annotation> getSameOffsetAnnotations(JCas jcas, Class<? extends Annotation> ann_class, int begin, int end) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        try {
            FSIterator<? extends Annotation> it = FeatureConstrainedIterator.getEnclosedIterator(jcas, ann_class, begin, begin + 1, end - 1, end);
            while (it.hasNext()) {
                result.add((Annotation)it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Annotation getSameOffsetAnnotation(JCas jcas, Class<? extends Annotation> ann_class, Annotation source) {
        return UIMAAnnotationUtils.getSameOffsetAnnotation(jcas, ann_class, source.getBegin(), source.getEnd());
    }

    public static List<Annotation> getSameOffsetAnnotations(JCas jcas, Class<? extends Annotation> ann_class, Annotation source) {
        return UIMAAnnotationUtils.getSameOffsetAnnotations(jcas, ann_class, source.getBegin(), source.getEnd());
    }

    public static FSIterator<? extends Annotation> fsIterator(JCas jcas, Class<? extends Annotation> cls_ann) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        AnnotationIndex ind = jcas.getJFSIndexRepository().getAnnotationIndex(UIMAAnnotationUtils.getTypeIndexId(cls_ann));
        return ind.iterator();
    }

    public static Class<? extends Annotation> getAnnotationClass(Class<?> cls) {
        if (!Annotation.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("class '" + cls.getName() + "' is not derived from " + Annotation.class.getName());
        }
        return cls;
    }

    public static <T extends Annotation> Iterator<T> iterator(JCas jcas, Class<T> cls) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        return UIMAAnnotationUtils.fsIterator(jcas, cls);
    }

    public static Class<? extends Annotation> forName(String name) throws ClassNotFoundException {
        return UIMAAnnotationUtils.getAnnotationClass(Class.forName(name));
    }

    public static <B extends Annotation, T extends B> Class<T> forName(Class<B> cls_base, String name) throws ClassNotFoundException {
        return UIMAAnnotationUtils.getAnnotationClass(Class.forName(name));
    }
}

