/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe.config.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.uima.tools.cfe.config.ConfigFactory;
import org.apache.uima.tools.cfe.config.ConfigPackage;
import org.apache.uima.tools.cfe.config.DocumentRoot;
import org.apache.uima.tools.cfe.config.util.ConfigResourceFactoryImpl;
import org.apache.uima.tools.cfe.config.util.ConfigResourceImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigResourceUtil {
    private static ConfigResourceUtil instance;

    public static ConfigResourceUtil getInstance() {
        if (instance == null) {
            instance = new ConfigResourceUtil();
        }
        return instance;
    }

    public ConfigResourceUtil() {
        this.initialize();
    }

    private void initialize() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xml", new ConfigResourceFactoryImpl());
        ConfigPackage pkg = ConfigPackage.eINSTANCE;
        ConfigFactory factory = ConfigFactory.eINSTANCE;
    }

    public DocumentRoot load(String filename) throws IOException {
        ConfigResourceImpl resource = (ConfigResourceImpl)new ConfigResourceFactoryImpl().createResource(URI.createURI((String)filename));
        resource.load(null);
        DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
        return documentRoot;
    }

    public DocumentRoot load(InputStream istream) throws IOException {
        ConfigResourceImpl resource = (ConfigResourceImpl)new ConfigResourceFactoryImpl().createResource(URI.createURI((String)"*.xml"));
        resource.load(istream, null);
        DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
        return documentRoot;
    }

    public void save(DocumentRoot documentRoot, String filename) throws IOException {
        ConfigResourceImpl resource = this.getConfigResourceImpl(documentRoot);
        resource.setURI(URI.createURI((String)filename));
        if (!resource.getContents().contains((Object)documentRoot)) {
            resource.getContents().add((Object)documentRoot);
        }
        resource.setEncoding("UTF-8");
        resource.save(null);
    }

    public void save(DocumentRoot documentRoot, OutputStream ostream) throws IOException {
        ConfigResourceImpl resource = this.getConfigResourceImpl(documentRoot);
        if (!resource.getContents().contains((Object)documentRoot)) {
            resource.getContents().add((Object)documentRoot);
        }
        resource.setEncoding("UTF-8");
        resource.save(ostream, null);
    }

    private ConfigResourceImpl getConfigResourceImpl(DocumentRoot documentRoot) {
        ConfigResourceImpl resource = (ConfigResourceImpl)documentRoot.eResource();
        if (resource == null) {
            resource = (ConfigResourceImpl)new ConfigResourceFactoryImpl().createResource(URI.createURI((String)"*.xml"));
        }
        return resource;
    }
}

