/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.ArrayDelimiterObject;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.PrimitiveFeatureTransformer;
import org.apache.uima.tools.cfe.support.ArrayComparatorFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetObjectMatcher {
    private Class<?> m_root_class;
    private Class<?> m_target_class;
    private String[] m_target_path_tokens;
    private final boolean m_delimit_array_values;
    private static final String KEYWORD_SORT = "sort";
    private static Pattern m_featname_pattern = Pattern.compile("([^\\[\\]]+)");
    private static Pattern m_parentPattern = Pattern.compile("__p([\\d]+)");

    private TargetObjectMatcher(Class<?> target_class, String[] full_target_path_tokens, boolean delimit_array_values) throws ClassNotFoundException {
        this.m_delimit_array_values = delimit_array_values;
        this.m_target_class = target_class;
        this.m_root_class = Class.forName(full_target_path_tokens[0]);
        this.m_target_path_tokens = new String[full_target_path_tokens.length - 1];
        for (int i = 1; i < full_target_path_tokens.length; ++i) {
            this.m_target_path_tokens[i - 1] = full_target_path_tokens[i];
        }
    }

    public TargetObjectMatcher(Class<? extends Object> target_class, String full_target_path, boolean delimit_array_values) throws ClassNotFoundException {
        this(target_class, full_target_path.split("\\:"), delimit_array_values);
    }

    public TargetObjectMatcher(String trg_cls_name, String full_target_path, boolean delimit_array_values) throws ClassNotFoundException {
        this(null == trg_cls_name || 0 == trg_cls_name.length() ? null : Class.forName(trg_cls_name), full_target_path, delimit_array_values);
    }

    Class<?> getRootClass() {
        return this.m_root_class;
    }

    Class<?> getTargetClass() {
        return this.m_target_class;
    }

    boolean isTargetClassMatches(Class<?> cls, boolean exact) {
        if (null == this.m_target_class) {
            return exact ? null == cls : true;
        }
        return exact ? this.m_target_class.equals(cls) : this.m_target_class.isAssignableFrom(cls);
    }

    String getFeaturePathImage() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_target_path_tokens.length; ++i) {
            if (0 != i) {
                result.append("_");
            }
            result.append(this.m_target_path_tokens[i]);
        }
        return result.toString();
    }

    boolean isDetached() {
        return this.isTargetClassMatches(this.m_root_class, true);
    }

    private static Method findGetMethod(Class<?> obj_class, String method_name) {
        return TargetObjectMatcher.findMethod(obj_class, method_name, null, null);
    }

    private static Method findMethod(Class<?> obj_class, String method_name, Class<?>[] method_params, Class<?> method_return) {
        Method[] mtds = obj_class.getMethods();
        for (int m_ind = 0; m_ind < mtds.length; ++m_ind) {
            if (!mtds[m_ind].getName().equals(method_name) || null == method_params && mtds[m_ind].getParameterTypes().length > 0 || null != method_params && !Arrays.equals(method_params, mtds[m_ind].getParameterTypes()) || null != method_return && !method_return.equals(mtds[m_ind].getReturnType())) continue;
            return mtds[m_ind];
        }
        return null;
    }

    static String parseFeatureName(String feature, List<String> postProcOps) {
        Matcher m = m_featname_pattern.matcher(feature);
        String result = null;
        while (m.find()) {
            String group = m.group();
            if (null == result) {
                result = group;
                continue;
            }
            postProcOps.add(group);
        }
        if (null == result) {
            return feature;
        }
        return result;
    }

    static Object[] processPostProcOps(Object[] elements, List<String> postProcOps) {
        ArrayList<Object> new_elements = new ArrayList<Object>();
        boolean use_new_elements = false;
        for (String op_name : postProcOps) {
            Comparator<Annotation> cmptr;
            if (op_name.matches("^\\d+")) {
                use_new_elements = true;
                int ind = Integer.parseInt(op_name);
                if (ind >= elements.length) continue;
                new_elements.add(elements[ind]);
                continue;
            }
            if (op_name.matches("\\d+..(-1|\\d+)")) {
                use_new_elements = true;
                String[] boundaries = op_name.split("\\.\\.");
                assert (2 == boundaries.length);
                int b = Integer.parseInt(boundaries[0]);
                int e = Integer.parseInt(boundaries[1]);
                int n = e = -1 == e ? elements.length - 1 : Math.min(e, elements.length - 1);
                while (b <= e) {
                    new_elements.add(elements[b++]);
                }
                continue;
            }
            if (!op_name.equals(KEYWORD_SORT)) continue;
            if (use_new_elements) {
                elements = new_elements.toArray();
                new_elements.clear();
            }
            if (null == (cmptr = ArrayComparatorFinder.find(elements))) continue;
            Arrays.sort((Annotation[])elements, cmptr);
        }
        if (use_new_elements) {
            elements = new_elements.toArray();
            new_elements.clear();
        }
        return elements;
    }

    public List<MatchedValue> getFeatureValues(MatchedValue mv) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<MatchedValue> result = new ArrayList<MatchedValue>();
        if (this.m_delimit_array_values) {
            result.add(new MatchedValue(new ArrayDelimiterObject(0), new ArrayList<Object>()));
        }
        if (!this.m_root_class.isAssignableFrom(mv.m_matchedObject.getClass())) {
            return result;
        }
        if (0 == this.m_target_path_tokens.length) {
            if (this.isTargetClassMatches(mv.m_matchedObject.getClass(), false)) {
                result.add(mv);
            }
            return result;
        }
        if (1 == this.m_target_path_tokens.length && this.m_target_path_tokens[0].contains("/")) {
            JXPathContext ctx = JXPathContext.newContext((Object)mv.m_matchedObject);
            ctx.setLenient(true);
            Iterator it = ctx.iterate(this.m_target_path_tokens[0]);
            while (it.hasNext()) {
                if (result.size() > 1 && this.m_delimit_array_values) {
                    result.add(new MatchedValue(new ArrayDelimiterObject(0), new ArrayList<Object>()));
                }
                result.add(new MatchedValue(it.next(), new ArrayList<Object>()));
            }
        } else {
            this.getMatchedValues(new Object[]{mv.m_matchedObject}, mv.m_orderedPath, this.m_target_path_tokens, 0, result, new ArrayList<Object>(), -1);
        }
        return result;
    }

    private void getMatchedValues(Object[] objs, List<Object> rootOrderedPath, String[] features, int feat_ind, List<MatchedValue> matchedValues, List<Object> matchedOrderedPath, int array_level) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] operations = feat_ind < features.length ? features[feat_ind].split("\\|") : null;
        for (int i = 0; i < objs.length; ++i) {
            if (feat_ind == features.length) {
                if (null != objs[i] && !this.isTargetClassMatches(objs[i].getClass(), false)) continue;
                matchedValues.add(new MatchedValue(objs[i], matchedOrderedPath));
                continue;
            }
            if (null == objs[i]) continue;
            matchedOrderedPath.add(objs[i]);
            ArrayList<Object> mop = 1 == objs.length ? matchedOrderedPath : new ArrayList<Object>(matchedOrderedPath);
            this.getMatchedValues(objs[i], rootOrderedPath, features, feat_ind, matchedValues, mop, array_level, operations);
            if (!this.m_delimit_array_values || i >= objs.length - 1) continue;
            matchedValues.add(new MatchedValue(new ArrayDelimiterObject(array_level), mop));
        }
    }

    Object getOperationResult(Object obj, List<Object> rootOrderedPath, String[] operations, List<String> postProcOps) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        for (int tok_ind = 0; tok_ind < operations.length; ++tok_ind) {
            postProcOps.clear();
            String feat_name = TargetObjectMatcher.parseFeatureName(operations[tok_ind], postProcOps);
            Matcher m = m_parentPattern.matcher(feat_name);
            int parInd = Integer.MIN_VALUE;
            if (m.find()) {
                parInd = Integer.parseInt(m.group(1));
                if (m.find()) {
                    throw new IllegalArgumentException("malformed operation name");
                }
                result = rootOrderedPath.get(parInd);
                break;
            }
            Method get_feat_method = TargetObjectMatcher.findGetMethod(obj.getClass(), feat_name);
            if (null == get_feat_method) {
                feat_name = "get" + PrimitiveFeatureTransformer.capitalize(feat_name);
                get_feat_method = TargetObjectMatcher.findGetMethod(obj.getClass(), feat_name);
                if (null == get_feat_method) {
                    System.err.println("Class \"" + obj.getClass().getName() + "\": Feature:\"" + feat_name + "\" is not found");
                    break;
                }
            }
            if (null != (result = get_feat_method.invoke(obj, (Object[])null))) break;
        }
        return result;
    }

    private void getMatchedValues(Object obj, List<Object> rootOrderedPath, String[] features, int feat_ind, List<MatchedValue> matchedValues, List<Object> matchedOrderedPath, int array_level, String[] operations) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> postProcOps = new ArrayList<String>();
        Object result = this.getOperationResult(obj, rootOrderedPath, operations, postProcOps);
        if (null == result) {
            matchedValues.add(new MatchedValue(null, matchedOrderedPath));
            return;
        }
        int next_feat_ind = feat_ind + 1;
        if (result.getClass().isArray()) {
            Object[] elements = (Object[])result;
            if (!postProcOps.isEmpty()) {
                elements = TargetObjectMatcher.processPostProcOps(elements, postProcOps);
            }
            if (this.m_delimit_array_values) {
                MatchedValue mv = matchedValues.get(0);
                mv.m_matchedObject = new ArrayDelimiterObject(array_level + 1);
            }
            this.getMatchedValues(elements, rootOrderedPath, features, next_feat_ind, matchedValues, matchedOrderedPath, array_level + 1);
        } else {
            this.getMatchedValues(new Object[]{result}, rootOrderedPath, features, next_feat_ind, matchedValues, matchedOrderedPath, array_level);
        }
    }
}

